/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Immutable;

final class BinaryValue
implements Immutable {
    private final byte[] value;

    private BinaryValue(byte[] value) {
        this.value = Objects.requireNonNull(value);
    }

    static Object wrap(Object value) {
        return value instanceof byte[] ? new BinaryValue((byte[])value) : value;
    }

    static Object wrapToString(Object value) {
        return value instanceof byte[] ? BinaryValue.toString((byte[])value) : value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BinaryValue && Arrays.equals(this.value, ((BinaryValue)obj).value);
    }

    public String toString() {
        return BinaryValue.toString(this.value);
    }

    private static String toString(byte[] value) {
        return Base64.getEncoder().encodeToString(value);
    }
}

