/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNode;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTreeSnapshot;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.LatestOperationHolder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

final class DataTreeState {
    private final LatestOperationHolder holder;
    private final EffectiveModelContext schemaContext;
    private final @NonNull TreeNode root;

    private DataTreeState(TreeNode root) {
        this.root = Objects.requireNonNull(root);
        this.holder = new LatestOperationHolder();
        this.schemaContext = null;
    }

    private DataTreeState(TreeNode root, LatestOperationHolder holder, EffectiveModelContext schemaContext) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.holder = Objects.requireNonNull(holder);
        this.root = Objects.requireNonNull(root);
    }

    static DataTreeState createInitial(TreeNode root) {
        return new DataTreeState(root);
    }

    @NonNull TreeNode getRoot() {
        return this.root;
    }

    InMemoryDataTreeSnapshot newSnapshot() {
        return new InMemoryDataTreeSnapshot(this.schemaContext, this.root, this.holder.newSnapshot());
    }

    DataTreeState withSchemaContext(EffectiveModelContext newSchemaContext, ModificationApplyOperation operation) {
        this.holder.setCurrent(operation);
        return new DataTreeState(this.root, this.holder, newSchemaContext);
    }

    DataTreeState withRoot(TreeNode newRoot) {
        return new DataTreeState(newRoot, this.holder, this.schemaContext);
    }

    public String toString() {
        TreeNode r = this.root;
        return MoreObjects.toStringHelper((Object)this).add("data", (Object)NormalizedNodes.toStringTree((NormalizedNode)r.getData())).toString();
    }
}

