/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.TreeNodeFactory;
import org.opendaylight.yangtools.yang.data.api.schema.tree.spi.Version;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.InMemoryDataTree;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(immediate=true)
public final class InMemoryDataTreeFactory
implements DataTreeFactory {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDataTreeFactory.class);
    private static final @NonNull NormalizedNode<?, ?> ROOT_CONTAINER = ImmutableNodes.containerNode(SchemaContext.NAME);

    @Inject
    public InMemoryDataTreeFactory() {
    }

    public DataTree create(DataTreeConfiguration treeConfig) {
        return new InMemoryDataTree(TreeNodeFactory.createTreeNode(InMemoryDataTreeFactory.createRoot(treeConfig.getRootPath()), (Version)Version.initial()), treeConfig, null);
    }

    public DataTree create(DataTreeConfiguration treeConfig, EffectiveModelContext initialSchemaContext) {
        return InMemoryDataTreeFactory.createDataTree(treeConfig, initialSchemaContext, true);
    }

    public DataTree create(DataTreeConfiguration treeConfig, EffectiveModelContext initialSchemaContext, NormalizedNodeContainer<?, ?, ?> initialRoot) throws DataValidationFailedException {
        DataTree ret = InMemoryDataTreeFactory.createDataTree(treeConfig, initialSchemaContext, false);
        DataTreeModification mod = ret.takeSnapshot().newModification();
        mod.write(YangInstanceIdentifier.empty(), initialRoot);
        mod.ready();
        ret.validate(mod);
        DataTreeCandidateTip candidate = ret.prepare(mod);
        ret.commit((DataTreeCandidate)candidate);
        return ret;
    }

    @Activate
    void activate() {
        LOG.info("In-memory Data Tree activated");
    }

    @Deactivate
    void deactivate() {
        LOG.info("In-memory Data Tree deactivated");
    }

    private static @NonNull DataTree createDataTree(DataTreeConfiguration treeConfig, EffectiveModelContext initialSchemaContext, boolean maskMandatory) {
        DataSchemaNode rootSchemaNode = InMemoryDataTreeFactory.getRootSchemaNode(initialSchemaContext, treeConfig.getRootPath());
        NormalizedNode<?, ?> rootDataNode = InMemoryDataTreeFactory.createRoot((DataNodeContainer)rootSchemaNode, treeConfig.getRootPath());
        return new InMemoryDataTree(TreeNodeFactory.createTreeNode(rootDataNode, (Version)Version.initial()), treeConfig, initialSchemaContext, rootSchemaNode, maskMandatory);
    }

    private static @NonNull NormalizedNode<?, ?> createRoot(DataNodeContainer schemaNode, YangInstanceIdentifier path) {
        if (path.isEmpty()) {
            Preconditions.checkArgument((boolean)(schemaNode instanceof ContainerLike), (String)"Conceptual tree root has to be a container, not %s", (Object)schemaNode);
            return ROOT_CONTAINER;
        }
        YangInstanceIdentifier.PathArgument arg = path.getLastPathArgument();
        if (schemaNode instanceof ContainerSchemaNode) {
            Preconditions.checkArgument((boolean)(arg instanceof YangInstanceIdentifier.NodeIdentifier), (String)"Mismatched container %s path %s", (Object)schemaNode, (Object)path);
            return ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifier)arg)).build();
        }
        if (schemaNode instanceof ListSchemaNode) {
            if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
                return ImmutableNodes.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifierWithPredicates)arg)).build();
            }
            Preconditions.checkArgument((boolean)(arg instanceof YangInstanceIdentifier.NodeIdentifier), (String)"Mismatched list %s path %s", (Object)schemaNode, (Object)path);
            return ImmutableNodes.mapNodeBuilder().withNodeIdentifier((YangInstanceIdentifier.NodeIdentifier)arg).build();
        }
        throw new IllegalArgumentException("Unsupported root schema " + schemaNode);
    }

    private static @NonNull NormalizedNode<?, ?> createRoot(YangInstanceIdentifier path) {
        if (path.isEmpty()) {
            return ROOT_CONTAINER;
        }
        YangInstanceIdentifier.PathArgument arg = path.getLastPathArgument();
        if (arg instanceof YangInstanceIdentifier.NodeIdentifier) {
            return ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifier)arg)).build();
        }
        if (arg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) {
            return ImmutableNodes.mapEntryBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)((YangInstanceIdentifier.NodeIdentifierWithPredicates)arg)).build();
        }
        throw new IllegalArgumentException("Unsupported root node " + arg);
    }

    private static DataSchemaNode getRootSchemaNode(EffectiveModelContext schemaContext, YangInstanceIdentifier rootPath) {
        DataSchemaContextTree contextTree = DataSchemaContextTree.from((EffectiveModelContext)schemaContext);
        Optional rootContextNode = contextTree.findChild(rootPath);
        Preconditions.checkArgument((boolean)rootContextNode.isPresent(), (String)"Failed to find root %s in schema context", (Object)rootPath);
        DataSchemaNode rootSchemaNode = ((DataSchemaContextNode)rootContextNode.get()).getDataSchemaNode();
        Preconditions.checkArgument((boolean)(rootSchemaNode instanceof DataNodeContainer), (String)"Root %s resolves to non-container type %s", (Object)rootPath, (Object)rootSchemaNode);
        return rootSchemaNode;
    }
}

