/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.MoreObjects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.RequiredElementCountException;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.AbstractValidation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.MinMaxElementsValidationFailedException;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.ModificationPath;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraint;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraintAware;

final class MinMaxElementsValidation<T extends DataSchemaNode & ElementCountConstraintAware>
extends AbstractValidation {
    private final int minElements;
    private final int maxElements;

    private MinMaxElementsValidation(SchemaAwareApplyOperation<T> delegate, Integer minElements, Integer maxElements) {
        super(delegate);
        this.minElements = minElements != null ? minElements : 0;
        this.maxElements = maxElements != null ? maxElements : Integer.MAX_VALUE;
    }

    static <T extends DataSchemaNode & ElementCountConstraintAware> ModificationApplyOperation from(SchemaAwareApplyOperation<T> delegate) {
        Optional optConstraint = ((ElementCountConstraintAware)((DataSchemaNode)delegate.getSchema())).getElementCountConstraint();
        if (!optConstraint.isPresent()) {
            return delegate;
        }
        ElementCountConstraint constraint = (ElementCountConstraint)optConstraint.get();
        return new MinMaxElementsValidation<T>(delegate, constraint.getMinElements(), constraint.getMaxElements());
    }

    @Override
    void enforceOnData(NormalizedNode<?, ?> data) {
        this.enforceOnData(data, (int actual, String message) -> new MinMaxElementsValidationFailedException(message));
    }

    @Override
    void enforceOnData(ModificationPath path, NormalizedNode<?, ?> data) throws RequiredElementCountException {
        this.enforceOnData(data, (int actual, String message) -> new RequiredElementCountException(path.toInstanceIdentifier(), this.minElements, this.maxElements, actual, message));
    }

    private <X extends Exception> void enforceOnData(NormalizedNode<?, ?> value, ExceptionSupplier<X> exceptionSupplier) throws X {
        int children = MinMaxElementsValidation.numOfChildrenFromValue(value);
        if (this.minElements > children) {
            throw exceptionSupplier.get(children, value.getIdentifier() + " does not have enough elements (" + children + "), needs at least " + this.minElements);
        }
        if (this.maxElements < children) {
            throw exceptionSupplier.get(children, value.getIdentifier() + " has too many elements (" + children + "), can have at most " + this.maxElements);
        }
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper.add("min", this.minElements).add("max", this.maxElements));
    }

    private static int numOfChildrenFromValue(NormalizedNode<?, ?> value) {
        if (value instanceof NormalizedNodeContainer) {
            return ((NormalizedNodeContainer)value).size();
        }
        if (value instanceof UnkeyedListNode) {
            return ((UnkeyedListNode)value).getSize();
        }
        throw new IllegalArgumentException(String.format("Unexpected type '%s', expected types are NormalizedNodeContainer and UnkeyedListNode", value.getClass()));
    }

    @FunctionalInterface
    @NonNullByDefault
    static interface ExceptionSupplier<T extends Exception> {
        public T get(int var1, String var2);
    }
}

