/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.tree;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collector;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.impl.schema.tree.BinaryValue;

final class UniqueValues
implements Immutable,
Iterable<Object> {
    static final Collector<Object, ?, UniqueValues> COLLECTOR = Collector.of(ArrayList::new, ArrayList::add, (left, right) -> {
        left.addAll(right);
        return left;
    }, list -> new UniqueValues(list.toArray()), new Collector.Characteristics[0]);
    private final Object[] objects;
    private final int hashCode;

    private UniqueValues(Object[] objects) {
        Verify.verify((objects.length != 0 ? 1 : 0) != 0);
        this.objects = objects;
        this.hashCode = Arrays.deepHashCode(objects);
    }

    @Override
    public Iterator<Object> iterator() {
        return new Itr(this.objects);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof UniqueValues && Arrays.deepEquals(this.objects, ((UniqueValues)obj).objects);
    }

    public String toString() {
        return UniqueValues.toString(this.objects);
    }

    private static String toString(Object[] objects) {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(BinaryValue.wrapToString(objects[0]));
        for (int i = 1; i < objects.length; ++i) {
            sb.append(", ").append(BinaryValue.wrapToString(objects[i]));
        }
        return sb.append(']').toString();
    }

    private static final class Itr
    implements Iterator<Object> {
        private final Object[] objects;
        private int offset = 0;

        Itr(Object[] objects) {
            this.objects = Objects.requireNonNull(objects);
        }

        @Override
        public boolean hasNext() {
            return this.offset < this.objects.length;
        }

        @Override
        public Object next() {
            int local = this.offset;
            if (local >= this.objects.length) {
                throw new NoSuchElementException();
            }
            this.offset = local + 1;
            return this.objects[local];
        }
    }
}

