/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.opendaylight.mdsal.binding.model.api.AccessModifier;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedPropertyBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.TypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.util.BindingTypes;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseTypes;
import org.opendaylight.yangtools.yang.model.util.type.DecimalTypeBuilder;

public final class BindingGeneratorUtil {
    private static final CharMatcher DASH_COLON_MATCHER = CharMatcher.anyOf((CharSequence)"-:");
    private static final CharMatcher GT_MATCHER = CharMatcher.is((char)'>');
    private static final CharMatcher LT_MATCHER = CharMatcher.is((char)'<');
    private static final Pattern UNICODE_CHAR_PATTERN = Pattern.compile("\\\\+u");
    private static final Restrictions EMPTY_RESTRICTIONS = new Restrictions(){

        public Optional<LengthConstraint> getLengthConstraint() {
            return Optional.empty();
        }

        public List<PatternConstraint> getPatternConstraints() {
            return Collections.emptyList();
        }

        public Optional<RangeConstraint<?>> getRangeConstraint() {
            return Optional.empty();
        }

        public boolean isEmpty() {
            return true;
        }
    };
    private static final Comparator<TypeMemberBuilder<?>> SUID_MEMBER_COMPARATOR = Comparator.comparing(TypeMemberBuilder::getName);
    private static final Comparator<Type> SUID_NAME_COMPARATOR = Comparator.comparing(Type::getFullyQualifiedName);
    private static final ImmutableSet<?> IGNORED_INTERFACES = ImmutableSet.of((Object)BindingTypes.TYPE_OBJECT, (Object)BindingTypes.SCALAR_TYPE_OBJECT);
    private static final ThreadLocal<MessageDigest> SHA1_MD = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to get a SHA digest provider", e);
        }
    });

    private BindingGeneratorUtil() {
    }

    public static String resolveJavaReservedWordEquivalency(String parameterName) {
        if (parameterName != null && BindingMapping.JAVA_RESERVED_WORDS.contains((Object)parameterName)) {
            return "_" + parameterName;
        }
        return parameterName;
    }

    public static String packageNameForGeneratedType(String basePackageName, SchemaPath schemaPath) {
        int size = Iterables.size((Iterable)schemaPath.getPathTowardsRoot()) - 1;
        if (size <= 0) {
            return basePackageName;
        }
        return BindingGeneratorUtil.generateNormalizedPackageName(basePackageName, schemaPath.getPathFromRoot(), size);
    }

    public static String packageNameForAugmentedGeneratedType(String basePackageName, SchemaPath schemaPath) {
        int size = Iterables.size((Iterable)schemaPath.getPathTowardsRoot());
        if (size == 0) {
            return basePackageName;
        }
        return BindingGeneratorUtil.generateNormalizedPackageName(basePackageName, schemaPath.getPathFromRoot(), size);
    }

    private static String generateNormalizedPackageName(String base, Iterable<QName> path, int size) {
        StringBuilder builder = new StringBuilder(base);
        Iterator<QName> iterator = path.iterator();
        for (int i = 0; i < size; ++i) {
            builder.append('.');
            String nodeLocalName = iterator.next().getLocalName();
            builder.append(DASH_COLON_MATCHER.replaceFrom((CharSequence)nodeLocalName, '.'));
        }
        return BindingMapping.normalizePackageName((String)builder.toString());
    }

    private static <T> Iterable<T> sortedCollection(Comparator<? super T> comparator, Collection<T> input) {
        if (input.size() <= 1) {
            return input;
        }
        ArrayList<T> ret = new ArrayList<T>(input);
        ret.sort(comparator);
        return ret;
    }

    public static long computeDefaultSUID(GeneratedTypeBuilderBase<?> to) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream dout = new DataOutputStream(bout);){
            dout.writeUTF(to.getName());
            dout.writeInt(to.isAbstract() ? 3 : 7);
            for (Type type : BindingGeneratorUtil.sortedCollection(SUID_NAME_COMPARATOR, BindingGeneratorUtil.filteredImplementsTypes(to))) {
                dout.writeUTF(type.getFullyQualifiedName());
            }
            for (GeneratedPropertyBuilder generatedPropertyBuilder : BindingGeneratorUtil.sortedCollection(SUID_MEMBER_COMPARATOR, to.getProperties())) {
                dout.writeUTF(generatedPropertyBuilder.getName());
            }
            for (MethodSignatureBuilder methodSignatureBuilder : BindingGeneratorUtil.sortedCollection(SUID_MEMBER_COMPARATOR, to.getMethodDefinitions())) {
                if (methodSignatureBuilder.getAccessModifier().equals((Object)AccessModifier.PRIVATE)) continue;
                dout.writeUTF(methodSignatureBuilder.getName());
                dout.write(methodSignatureBuilder.getAccessModifier().ordinal());
            }
            dout.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to hash object " + to, e);
        }
        byte[] hashBytes = SHA1_MD.get().digest(bout.toByteArray());
        long hash = 0L;
        for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
            hash = hash << 8 | (long)(hashBytes[i] & 0xFF);
        }
        return hash;
    }

    private static Collection<Type> filteredImplementsTypes(GeneratedTypeBuilderBase<?> to) {
        return Collections2.filter((Collection)to.getImplementsTypes(), item -> !IGNORED_INTERFACES.contains(item));
    }

    private static <T extends Optional<?>> T currentOrEmpty(T current, T base) {
        return (T)(current.equals(base) ? Optional.empty() : current);
    }

    private static boolean containsConstraint(StringTypeDefinition type, PatternConstraint constraint) {
        for (StringTypeDefinition wlk = type; wlk != null; wlk = (StringTypeDefinition)wlk.getBaseType()) {
            if (!wlk.getPatternConstraints().contains(constraint)) continue;
            return true;
        }
        return false;
    }

    private static List<PatternConstraint> uniquePatterns(StringTypeDefinition type) {
        List constraints = type.getPatternConstraints();
        if (constraints.isEmpty()) {
            return constraints;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean filtered = false;
        for (PatternConstraint c : constraints) {
            if (BindingGeneratorUtil.containsConstraint((StringTypeDefinition)type.getBaseType(), c)) {
                filtered = true;
                continue;
            }
            builder.add((Object)c);
        }
        return filtered ? builder.build() : constraints;
    }

    public static Restrictions getRestrictions(TypeDefinition<?> type) {
        Optional range;
        Object pattern;
        Optional length;
        if (type == null || type.getBaseType() == null) {
            if (type instanceof DecimalTypeDefinition) {
                final DecimalTypeDefinition decimal = (DecimalTypeDefinition)type;
                DecimalTypeBuilder tmpBuilder = BaseTypes.decimalTypeBuilder((SchemaPath)decimal.getPath());
                tmpBuilder.setFractionDigits(decimal.getFractionDigits());
                DecimalTypeDefinition tmp = (DecimalTypeDefinition)tmpBuilder.build();
                if (!tmp.getRangeConstraint().equals(decimal.getRangeConstraint())) {
                    return new Restrictions(){

                        public boolean isEmpty() {
                            return false;
                        }

                        public Optional<? extends RangeConstraint<?>> getRangeConstraint() {
                            return decimal.getRangeConstraint();
                        }

                        public List<PatternConstraint> getPatternConstraints() {
                            return ImmutableList.of();
                        }

                        public Optional<LengthConstraint> getLengthConstraint() {
                            return Optional.empty();
                        }
                    };
                }
            }
            return EMPTY_RESTRICTIONS;
        }
        if (type instanceof BinaryTypeDefinition) {
            BinaryTypeDefinition binary = (BinaryTypeDefinition)type;
            BinaryTypeDefinition base = (BinaryTypeDefinition)binary.getBaseType();
            length = base != null && base.getBaseType() != null ? BindingGeneratorUtil.currentOrEmpty(binary.getLengthConstraint(), base.getLengthConstraint()) : binary.getLengthConstraint();
            pattern = ImmutableList.of();
            range = Optional.empty();
        } else if (type instanceof DecimalTypeDefinition) {
            length = Optional.empty();
            pattern = ImmutableList.of();
            DecimalTypeDefinition decimal = (DecimalTypeDefinition)type;
            DecimalTypeDefinition base = (DecimalTypeDefinition)decimal.getBaseType();
            range = base != null && base.getBaseType() != null ? BindingGeneratorUtil.currentOrEmpty(decimal.getRangeConstraint(), base.getRangeConstraint()) : decimal.getRangeConstraint();
        } else if (type instanceof RangeRestrictedTypeDefinition) {
            length = Optional.empty();
            pattern = ImmutableList.of();
            range = BindingGeneratorUtil.extractRangeConstraint((RangeRestrictedTypeDefinition)type);
        } else if (type instanceof StringTypeDefinition) {
            StringTypeDefinition string = (StringTypeDefinition)type;
            StringTypeDefinition base = (StringTypeDefinition)string.getBaseType();
            length = base != null && base.getBaseType() != null ? BindingGeneratorUtil.currentOrEmpty(string.getLengthConstraint(), base.getLengthConstraint()) : string.getLengthConstraint();
            pattern = BindingGeneratorUtil.uniquePatterns(string);
            range = Optional.empty();
        } else {
            length = Optional.empty();
            pattern = ImmutableList.of();
            range = Optional.empty();
        }
        if (!length.isPresent() && pattern.isEmpty() && !range.isPresent()) {
            return EMPTY_RESTRICTIONS;
        }
        return new Restrictions((List)pattern, length){
            final /* synthetic */ List val$pattern;
            final /* synthetic */ Optional val$length;
            {
                this.val$pattern = list;
                this.val$length = optional2;
            }

            public Optional<? extends RangeConstraint<?>> getRangeConstraint() {
                return range;
            }

            public List<PatternConstraint> getPatternConstraints() {
                return this.val$pattern;
            }

            public Optional<LengthConstraint> getLengthConstraint() {
                return this.val$length;
            }

            public boolean isEmpty() {
                return false;
            }
        };
    }

    private static <T extends RangeRestrictedTypeDefinition<?, ?>> Optional<? extends RangeConstraint<?>> extractRangeConstraint(T def) {
        RangeRestrictedTypeDefinition base = (RangeRestrictedTypeDefinition)def.getBaseType();
        if (base != null && base.getBaseType() != null) {
            return BindingGeneratorUtil.currentOrEmpty(def.getRangeConstraint(), base.getRangeConstraint());
        }
        return def.getRangeConstraint();
    }

    public static String encodeAngleBrackets(String description) {
        if (description != null) {
            description = LT_MATCHER.replaceFrom((CharSequence)description, (CharSequence)"&lt;");
            description = GT_MATCHER.replaceFrom((CharSequence)description, (CharSequence)"&gt;");
        }
        return description;
    }

    public static String replaceAllIllegalChars(String str) {
        int backslash = str.indexOf(92);
        return backslash == -1 ? str : BindingGeneratorUtil.defangUnicodeEscapes(str);
    }

    private static String defangUnicodeEscapes(String str) {
        String ret = UNICODE_CHAR_PATTERN.matcher(str).replaceAll("\\\\\\\\u");
        return ret.isEmpty() ? "" : ret;
    }
}

