/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.TypeComment;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractEnumerationBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractGeneratedType;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractGeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.CodegenEnumerationBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public final class CodegenGeneratedTypeBuilder
extends AbstractGeneratedTypeBuilder<GeneratedTypeBuilder>
implements GeneratedTypeBuilder {
    private String description;
    private String reference;
    private String moduleName;
    private SchemaPath schemaPath;

    public CodegenGeneratedTypeBuilder(JavaTypeName identifier) {
        super(identifier);
        this.setAbstract(true);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setSchemaPath(SchemaPath schemaPath) {
        this.schemaPath = schemaPath;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GeneratedTransferObject [packageName=");
        builder.append(this.getPackageName());
        builder.append(", name=");
        builder.append(this.getName());
        TypeComment comment = this.getComment();
        if (comment != null) {
            builder.append(", comment=");
            builder.append(comment.getJavadoc());
        }
        builder.append(", annotations=");
        builder.append(this.getAnnotations());
        builder.append(", implements=");
        builder.append(this.getImplementsTypes());
        builder.append(", enclosedTypes=");
        builder.append(this.getEnclosedTypes());
        builder.append(", constants=");
        builder.append(this.getConstants());
        builder.append(", enumerations=");
        builder.append(this.getEnumerations());
        builder.append(", properties=");
        builder.append(", methods=");
        builder.append(this.getMethodDefinitions());
        builder.append("]");
        return builder.toString();
    }

    public GeneratedType build() {
        return new GeneratedTypeImpl(this);
    }

    @Override
    AbstractEnumerationBuilder newEnumerationBuilder(JavaTypeName identifier) {
        return new CodegenEnumerationBuilder(identifier);
    }

    @Override
    protected CodegenGeneratedTypeBuilder thisInstance() {
        return this;
    }

    private static final class GeneratedTypeImpl
    extends AbstractGeneratedType {
        private final String description;
        private final String reference;
        private final String moduleName;
        private final SchemaPath schemaPath;

        GeneratedTypeImpl(CodegenGeneratedTypeBuilder builder) {
            super(builder);
            this.description = builder.description;
            this.reference = builder.reference;
            this.moduleName = builder.moduleName;
            this.schemaPath = builder.schemaPath;
        }

        public String getDescription() {
            return this.description;
        }

        public String getReference() {
            return this.reference;
        }

        public Iterable<QName> getSchemaPath() {
            return this.schemaPath.getPathFromRoot();
        }

        public String getModuleName() {
            return this.moduleName;
        }
    }
}

