/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.util.generated.type.builder;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.AbstractTypeMemberBuilder;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.MethodParameterImpl;
import org.opendaylight.mdsal.binding.model.util.generated.type.builder.MethodSignatureImpl;
import org.opendaylight.yangtools.util.LazyCollections;

final class MethodSignatureBuilderImpl
extends AbstractTypeMemberBuilder<MethodSignatureBuilder>
implements MethodSignatureBuilder {
    private List<MethodSignature.Parameter> parameters = Collections.emptyList();
    private List<MethodSignature.Parameter> unmodifiableParams = Collections.emptyList();
    private MethodSignature.ValueMechanics mechanics = MethodSignature.ValueMechanics.NORMAL;
    private boolean isAbstract;
    private boolean isDefault;

    MethodSignatureBuilderImpl(String name) {
        super(name);
    }

    public MethodSignatureBuilder setAbstract(boolean newIsAbstract) {
        this.isAbstract = newIsAbstract;
        return this;
    }

    public MethodSignatureBuilder setDefault(boolean newIsDefault) {
        this.isDefault = newIsDefault;
        return this;
    }

    public MethodSignatureBuilder setMechanics(MethodSignature.ValueMechanics newMechanics) {
        this.mechanics = Objects.requireNonNull(newMechanics);
        return this;
    }

    public MethodSignatureBuilder addParameter(Type type, String name) {
        this.parameters = LazyCollections.lazyAdd(this.parameters, (Object)new MethodParameterImpl(name, type));
        this.unmodifiableParams = Collections.unmodifiableList(this.parameters);
        return this;
    }

    @Override
    protected MethodSignatureBuilder thisInstance() {
        return this;
    }

    public MethodSignature toInstance(Type definingType) {
        List<AnnotationType> annotations = this.toAnnotationTypes();
        return new MethodSignatureImpl(definingType, this.getName(), annotations, this.getComment(), this.getAccessModifier(), this.getReturnType(), this.unmodifiableParams, this.isFinal(), this.isAbstract, this.isStatic(), this.isDefault, this.mechanics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName(), this.parameters, this.getReturnType());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignatureBuilderImpl other = (MethodSignatureBuilderImpl)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.parameters, other.parameters) && Objects.equals(this.getReturnType(), other.getReturnType());
    }

    @Override
    public String toString() {
        return "MethodSignatureBuilderImpl [name=" + this.getName() + ", returnType=" + this.getReturnType() + ", parameters=" + this.parameters + ", annotationBuilders=" + this.getAnnotationBuilders() + ", comment=" + this.getComment() + ']';
    }
}

