/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.conduits;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class BlockingStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private boolean resumed;

    public BlockingStreamSourceConduit(StreamSourceConduit next) {
        super(next);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).transferTo(position, count, target);
        }
        while ((res = ((StreamSourceConduit)this.next).transferTo(position, count, target)) == 0L) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).transferTo(count, throughBuffer, target);
        }
        while ((res = ((StreamSourceConduit)this.next).transferTo(count, throughBuffer, target)) == 0L && !throughBuffer.hasRemaining()) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).read(dst);
        }
        while ((res = ((StreamSourceConduit)this.next).read(dst)) == 0) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        long res;
        if (this.resumed) {
            return ((StreamSourceConduit)this.next).read(dsts, offs, len);
        }
        while ((res = ((StreamSourceConduit)this.next).read(dsts, offs, len)) == 0L) {
            ((StreamSourceConduit)this.next).awaitReadable();
        }
        return res;
    }

    @Override
    public void resumeReads() {
        this.resumed = true;
        ((StreamSourceConduit)this.next).resumeReads();
    }

    @Override
    public void wakeupReads() {
        this.resumed = true;
        ((StreamSourceConduit)this.next).wakeupReads();
    }

    @Override
    public void suspendReads() {
        this.resumed = false;
        ((StreamSourceConduit)this.next).suspendReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.resumed;
    }
}

