/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.gson.stream.JsonWriter;
import java.io.Writer;

@Beta
public final class JsonWriterFactory {
    private JsonWriterFactory() {
    }

    public static JsonWriter createJsonWriter(Writer writer) {
        return new JsonWriter(writer);
    }

    public static JsonWriter createJsonWriter(Writer writer, int indentSize) {
        JsonWriter jsonWriter = new JsonWriter(writer);
        String indent = " ".repeat(indentSize);
        jsonWriter.setIndent(indent);
        return jsonWriter;
    }
}

