/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api.query;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.api.query.SimpleDOMQueryResult;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
@NonNullByDefault
public interface DOMQueryResult
extends Iterable<Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>>,
Immutable {
    default public Stream<Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    default public List<? extends Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> items() {
        return this.stream().collect(Collectors.toUnmodifiableList());
    }

    public static DOMQueryResult of() {
        return SimpleDOMQueryResult.EMPTY_INSTANCE;
    }

    public static DOMQueryResult of(Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> item) {
        return new SimpleDOMQueryResult(ImmutableList.of(item));
    }

    public static DOMQueryResult of(List<Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>>> items) {
        return items.isEmpty() ? DOMQueryResult.of() : new SimpleDOMQueryResult(items);
    }
}

