/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.dom.spi.shard.ChildShardContext;
import org.opendaylight.mdsal.dom.store.inmemory.AbstractDOMShardTreeChangePublisher;
import org.opendaylight.yangtools.util.concurrent.QueuedNotificationManager;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTree;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InMemoryDOMDataTreeShardChangePublisher
extends AbstractDOMShardTreeChangePublisher {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryDOMDataTreeShardChangePublisher.class);
    private final QueuedNotificationManager<AbstractDOMDataTreeChangeListenerRegistration<?>, DataTreeCandidate> notificationManager;

    InMemoryDOMDataTreeShardChangePublisher(Executor executor, int maxQueueSize, DataTree dataTree, YangInstanceIdentifier rootPath, Map<DOMDataTreeIdentifier, ChildShardContext> childShards) {
        super(dataTree, rootPath, childShards);
        this.notificationManager = QueuedNotificationManager.create((Executor)executor, (listener, notifications) -> {
            if (!listener.isClosed()) {
                ((DOMDataTreeChangeListener)listener.getInstance()).onDataTreeChanged((Collection)notifications);
            }
        }, (int)maxQueueSize, (String)"DataTreeChangeListenerQueueMgr");
    }

    protected void notifyListener(AbstractDOMDataTreeChangeListenerRegistration<?> registration, Collection<DataTreeCandidate> changes) {
        LOG.debug("Enqueueing candidates {} for registration {}", changes, registration);
        this.notificationManager.submitNotifications(registration, changes);
    }

    protected void registrationRemoved(AbstractDOMDataTreeChangeListenerRegistration<?> registration) {
        LOG.debug("Closing registration {}", registration);
    }

    synchronized void publishChange(DataTreeCandidate candidate) {
        this.processCandidateTree(candidate);
    }
}

