/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.mdsal.dom.store.inmemory.InmemoryDOMDataTreeShardWriteTransaction;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ShardCommitCoordinationTask
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ShardCommitCoordinationTask.class);
    private final DOMDataTreeIdentifier rootShardPrefix;
    private final Collection<DOMStoreThreePhaseCommitCohort> cohorts;
    private InmemoryDOMDataTreeShardWriteTransaction transaction;

    public ShardCommitCoordinationTask(DOMDataTreeIdentifier rootShardPrefix, Collection<DOMStoreThreePhaseCommitCohort> cohorts, InmemoryDOMDataTreeShardWriteTransaction transaction) {
        this.rootShardPrefix = Objects.requireNonNull(rootShardPrefix);
        this.cohorts = Objects.requireNonNull(cohorts);
        this.transaction = Objects.requireNonNull(transaction);
    }

    @Override
    public Void call() throws TransactionCommitFailedException {
        try {
            LOG.debug("Shard {}, commit started", (Object)this.rootShardPrefix);
            this.commitBlocking();
            this.transaction.transactionCommited(this.transaction);
            return null;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Shard: {} Submit Error during phase Commit, starting Abort", (Object)this.rootShardPrefix, (Object)e);
            throw e;
        }
    }

    void commitBlocking() throws TransactionCommitFailedException {
        for (ListenableFuture<?> commit : this.commitAll()) {
            try {
                commit.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TransactionCommitFailedException("Commit failed", (Throwable)e, new RpcError[0]);
            }
        }
    }

    private ListenableFuture<?>[] commitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[index++] = cohort.commit();
        }
        return ops;
    }
}

