/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.spi.shard.ForeignShardModificationContext;
import org.opendaylight.mdsal.dom.spi.shard.WritableNodeOperation;
import org.opendaylight.mdsal.dom.spi.shard.WriteCursorStrategy;
import org.opendaylight.mdsal.dom.spi.shard.WriteableModificationNode;
import org.opendaylight.mdsal.dom.spi.shard.WriteableNodeWithSubshard;
import org.opendaylight.mdsal.dom.store.inmemory.ShardRootModificationContext;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;

public final class ShardDataModification
extends WriteableNodeWithSubshard {
    private final ShardRootModificationContext rootContext;
    private final Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards;

    ShardDataModification(ShardRootModificationContext boundary, Map<YangInstanceIdentifier.PathArgument, WriteableModificationNode> subshards, Map<DOMDataTreeIdentifier, ForeignShardModificationContext> childShards) {
        super(subshards);
        this.rootContext = Objects.requireNonNull(boundary);
        this.childShards = ImmutableMap.copyOf(childShards);
    }

    public WriteCursorStrategy createOperation(DOMDataTreeWriteCursor parentCursor) {
        return new WritableNodeOperation((WriteableModificationNode)this, this.rootContext.cursor()){

            public void exit() {
                throw new IllegalStateException("Can not exit data tree root");
            }
        };
    }

    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.rootContext.getIdentifier().getRootIdentifier().getLastPathArgument();
    }

    DOMDataTreeIdentifier getPrefix() {
        return this.rootContext.getIdentifier();
    }

    Map<DOMDataTreeIdentifier, ForeignShardModificationContext> getChildShards() {
        return this.childShards;
    }

    DataTreeModification seal() {
        DataTreeModification rootModification = this.rootContext.ready();
        for (ForeignShardModificationContext childShard : this.childShards.values()) {
            childShard.ready();
        }
        return rootModification;
    }

    void closeTransactions() {
        for (ForeignShardModificationContext childShard : this.childShards.values()) {
            childShard.closeForeignTransaction();
        }
    }

    void closeCursor() {
        this.rootContext.closeCursor();
    }
}

