/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.store.inmemory;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ShardPreCommitCoordinationTask
implements Callable<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(ShardPreCommitCoordinationTask.class);
    private final DOMDataTreeIdentifier rootShardPrefix;
    private final Collection<DOMStoreThreePhaseCommitCohort> cohorts;

    public ShardPreCommitCoordinationTask(DOMDataTreeIdentifier rootShardPrefix, Collection<DOMStoreThreePhaseCommitCohort> cohorts) {
        this.rootShardPrefix = Objects.requireNonNull(rootShardPrefix);
        this.cohorts = Objects.requireNonNull(cohorts);
    }

    @Override
    public Void call() throws TransactionCommitFailedException {
        try {
            LOG.debug("Shard {}, preCommit started", (Object)this.rootShardPrefix);
            this.preCommitBlocking();
            return null;
        }
        catch (TransactionCommitFailedException e) {
            LOG.warn("Shard: {} Submit Error during phase PreCommit, starting Abort", (Object)this.rootShardPrefix, (Object)e);
            throw e;
        }
    }

    void preCommitBlocking() throws TransactionCommitFailedException {
        for (ListenableFuture<?> preCommit : this.preCommitAll()) {
            try {
                preCommit.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new TransactionCommitFailedException("PreCommit failed", (Throwable)e, new RpcError[0]);
            }
        }
    }

    private ListenableFuture<?>[] preCommitAll() {
        ListenableFuture[] ops = new ListenableFuture[this.cohorts.size()];
        int index = 0;
        for (DOMStoreThreePhaseCommitCohort cohort : this.cohorts) {
            ops[index++] = cohort.preCommit();
        }
        return ops;
    }
}

