/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.spi;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.DefaultModuleInfoSnapshot;
import org.opendaylight.mdsal.binding.runtime.spi.ModuleInfoSnapshotResolver;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.CheckedBuilder;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.model.parser.api.YangParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

@Beta
public final class ModuleInfoSnapshotBuilder
implements CheckedBuilder<ModuleInfoSnapshot, YangParserException> {
    private final Set<YangModuleInfo> moduleInfos = new HashSet<YangModuleInfo>();
    private final YangParserFactory parserFactory;

    public ModuleInfoSnapshotBuilder(YangParserFactory parserFactory) {
        this.parserFactory = Objects.requireNonNull(parserFactory);
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Class<? extends BindingObject> clazz) {
        YangModuleInfo moduleInfo;
        try {
            moduleInfo = BindingReflections.getModuleInfo(clazz);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to introspect " + clazz, e);
        }
        return this.add(moduleInfo);
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Class<? extends BindingObject> ... classes) {
        for (Class<? extends BindingObject> clazz : classes) {
            this.add(clazz);
        }
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(YangModuleInfo info) {
        ModuleInfoSnapshotResolver.flatDependencies(this.moduleInfos, info);
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(YangModuleInfo ... infos) {
        for (YangModuleInfo info : infos) {
            this.add(info);
        }
        return this;
    }

    public @NonNull ModuleInfoSnapshotBuilder add(Iterable<? extends YangModuleInfo> infos) {
        for (YangModuleInfo yangModuleInfo : infos) {
            this.add(yangModuleInfo);
        }
        return this;
    }

    public ModuleInfoSnapshot build() throws YangParserException {
        YangParser parser = this.parserFactory.createParser();
        HashMap<SourceIdentifier, YangModuleInfo> mappedInfos = new HashMap<SourceIdentifier, YangModuleInfo>();
        HashMap<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();
        for (YangModuleInfo info : this.moduleInfos) {
            YangTextSchemaSource source = ModuleInfoSnapshotResolver.toYangTextSource(info);
            mappedInfos.put(source.getIdentifier(), info);
            Class<?> infoClass = info.getClass();
            classLoaders.put(BindingReflections.getModelRootPackageName((Package)infoClass.getPackage()), infoClass.getClassLoader());
            try {
                parser.addSource((SchemaSourceRepresentation)source);
            }
            catch (IOException | YangSyntaxErrorException e) {
                throw new YangParserException("Failed to add source for " + info, e);
            }
        }
        return new DefaultModuleInfoSnapshot(parser.buildEffectiveModel(), mappedInfos, classLoaders);
    }
}

