/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.RpcContext;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.common.rev170215.RpcContextKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class RpcContextBuilder
implements Builder<RpcContext> {
    private String _identifier;
    private RpcContextKey key;
    Map<Class<? extends Augmentation<RpcContext>>, Augmentation<RpcContext>> augmentation = Collections.emptyMap();

    public RpcContextBuilder() {
    }

    public RpcContextBuilder(RpcContext base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RpcContext>>, Augmentation<RpcContext>>(aug);
        }
        this.key = base.key();
        this._identifier = base.getIdentifier();
    }

    public RpcContextKey key() {
        return this.key;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public <E$$ extends Augmentation<RpcContext>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public RpcContextBuilder withKey(RpcContextKey key) {
        this.key = key;
        return this;
    }

    public RpcContextBuilder setIdentifier(String value) {
        this._identifier = value;
        return this;
    }

    public RpcContextBuilder addAugmentation(Augmentation<RpcContext> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<RpcContext>>, Augmentation<RpcContext>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public RpcContextBuilder removeAugmentation(Class<? extends Augmentation<RpcContext>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public RpcContext build() {
        return new RpcContextImpl(this);
    }

    private static final class RpcContextImpl
    extends AbstractAugmentable<RpcContext>
    implements RpcContext {
        private final String _identifier;
        private final RpcContextKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        RpcContextImpl(RpcContextBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new RpcContextKey(base.getIdentifier());
            this._identifier = this.key.getIdentifier();
        }

        @Override
        public RpcContextKey key() {
            return this.key;
        }

        @Override
        public String getIdentifier() {
            return this._identifier;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = RpcContext.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return RpcContext.bindingEquals(this, obj);
        }

        public String toString() {
            return RpcContext.bindingToString(this);
        }
    }
}

