/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPerson;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.people.rev140818.car.people.CarPersonKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.rev140818.CarId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.PersonId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class CarPersonBuilder
implements Builder<CarPerson> {
    private CarId _carId;
    private PersonId _personId;
    private CarPersonKey key;
    Map<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>> augmentation = Collections.emptyMap();

    public CarPersonBuilder() {
    }

    public CarPersonBuilder(CarPerson base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>(aug);
        }
        this.key = base.key();
        this._carId = base.getCarId();
        this._personId = base.getPersonId();
    }

    public CarPersonKey key() {
        return this.key;
    }

    public CarId getCarId() {
        return this._carId;
    }

    public PersonId getPersonId() {
        return this._personId;
    }

    public <E$$ extends Augmentation<CarPerson>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public CarPersonBuilder withKey(CarPersonKey key) {
        this.key = key;
        return this;
    }

    public CarPersonBuilder setCarId(CarId value) {
        this._carId = value;
        return this;
    }

    public CarPersonBuilder setPersonId(PersonId value) {
        this._personId = value;
        return this;
    }

    public CarPersonBuilder addAugmentation(Augmentation<CarPerson> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<CarPerson>>, Augmentation<CarPerson>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public CarPersonBuilder removeAugmentation(Class<? extends Augmentation<CarPerson>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public CarPerson build() {
        return new CarPersonImpl(this);
    }

    private static final class CarPersonImpl
    extends AbstractAugmentable<CarPerson>
    implements CarPerson {
        private final CarId _carId;
        private final PersonId _personId;
        private final CarPersonKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        CarPersonImpl(CarPersonBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new CarPersonKey(base.getCarId(), base.getPersonId());
            this._carId = this.key.getCarId();
            this._personId = this.key.getPersonId();
        }

        @Override
        public CarPersonKey key() {
            return this.key;
        }

        @Override
        public CarId getCarId() {
            return this._carId;
        }

        @Override
        public PersonId getPersonId() {
            return this._personId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = CarPerson.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return CarPerson.bindingEquals(this, obj);
        }

        public String toString() {
            return CarPerson.bindingToString(this);
        }
    }
}

