/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.impl;

import javax.xml.xpath.XPathExpressionException;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.QualifiedQName;
import org.opendaylight.yangtools.yang.common.UnqualifiedQName;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.xpath.api.YangLiteralExpr;
import org.opendaylight.yangtools.yang.xpath.api.YangQNameExpr;

final class Utils {
    private Utils() {
    }

    static YangQNameExpr.Unresolved interpretAsQName(YangLiteralExpr expr) throws XPathExpressionException {
        UnqualifiedQName qname;
        String text = expr.getLiteral();
        int colon = text.indexOf(58);
        try {
            qname = colon != -1 ? QualifiedQName.of((String)text.substring(0, colon), (String)text.substring(colon + 1)) : UnqualifiedQName.of((String)text);
        }
        catch (IllegalArgumentException e) {
            throw Utils.wrapException(e, "Cannot interpret %s as a QName", expr);
        }
        return YangQNameExpr.of((AbstractQName)qname.intern());
    }

    static YangQNameExpr interpretAsQName(YangNamespaceContext namespaceContext, YangLiteralExpr expr) throws XPathExpressionException {
        String text = expr.getLiteral();
        int colon = text.indexOf(58);
        try {
            if (colon == -1) {
                return YangQNameExpr.of((AbstractQName)UnqualifiedQName.of((String)text).intern());
            }
            return YangQNameExpr.of((QName)namespaceContext.createQName(text.substring(0, colon), text.substring(colon + 1)));
        }
        catch (IllegalArgumentException e) {
            throw Utils.wrapException(e, "Cannot interpret %s as a QName", expr);
        }
    }

    static YangQNameExpr.Resolved interpretAsQName(YangNamespaceContext namespaceContext, QNameModule defaultNamespace, YangLiteralExpr expr) throws XPathExpressionException {
        QName qname;
        String text = expr.getLiteral();
        int colon = text.indexOf(58);
        try {
            qname = colon == -1 ? QName.create((QNameModule)defaultNamespace, (String)text).intern() : namespaceContext.createQName(text.substring(0, colon), text.substring(colon + 1));
        }
        catch (IllegalArgumentException e) {
            throw Utils.wrapException(e, "Cannot interpret %s as a QName", expr);
        }
        return YangQNameExpr.of((QName)qname);
    }

    static XPathExpressionException wrapException(@Nullable Throwable cause, String format, Object ... args) {
        XPathExpressionException ret = new XPathExpressionException(String.format(format, args));
        ret.initCause(cause);
        return ret;
    }
}

