/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.annotations.Beta;
import java.util.Collection;
import org.opendaylight.yangtools.yang.model.parser.api.YangParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.parser.impl.YangParserFactoryImpl;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParserFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true)
public final class OSGiYangParserFactory
implements YangParserFactory {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiYangParserFactory.class);
    @Reference
    YangXPathParserFactory xpathFactory = null;
    private YangParserFactory delegate = null;

    @Activate
    void activate() {
        this.delegate = new YangParserFactoryImpl(this.xpathFactory);
        LOG.info("YANG Parser activated");
    }

    @Deactivate
    void deactivate() {
        LOG.info("YANG Parser deactivated");
        this.delegate = null;
    }

    public Collection<StatementParserMode> supportedParserModes() {
        return this.delegate.supportedParserModes();
    }

    public YangParser createParser(StatementParserMode parserMode) {
        return this.delegate.createParser(parserMode);
    }
}

