/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DependencyResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DependencyResolver.class);
    private final ImmutableList<SourceIdentifier> resolvedSources;
    private final ImmutableList<SourceIdentifier> unresolvedSources;
    private final ImmutableMultimap<SourceIdentifier, ModuleImport> unsatisfiedImports;

    protected DependencyResolver(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        boolean progress;
        ArrayList<SourceIdentifier> resolved = new ArrayList<SourceIdentifier>(depInfo.size());
        ArrayList<SourceIdentifier> pending = new ArrayList<SourceIdentifier>(depInfo.keySet());
        HashMap<SourceIdentifier, BelongsToDependency> submodules = new HashMap<SourceIdentifier, BelongsToDependency>();
        do {
            progress = false;
            Iterator<Object> it = pending.iterator();
            while (it.hasNext()) {
                SourceIdentifier sourceIdentifier = (SourceIdentifier)it.next();
                YangModelDependencyInfo dep = depInfo.get(sourceIdentifier);
                boolean okay = true;
                ImmutableSet dependencies = dep.getDependencies();
                if (dep instanceof YangModelDependencyInfo.SubmoduleDependencyInfo) {
                    String parent = ((YangModelDependencyInfo.SubmoduleDependencyInfo)dep).getParentModule();
                    submodules.put(sourceIdentifier, new BelongsToDependency(parent));
                }
                for (ModuleImport mi : dependencies) {
                    if (this.isKnown(resolved, mi)) continue;
                    LOG.debug("Source {} is missing import {}", (Object)sourceIdentifier, (Object)mi);
                    okay = false;
                    break;
                }
                if (!okay) continue;
                LOG.debug("Resolved source {}", (Object)sourceIdentifier);
                resolved.add(sourceIdentifier);
                it.remove();
                progress = true;
            }
        } while (progress);
        for (Map.Entry entry : submodules.entrySet()) {
            BelongsToDependency belongs = (BelongsToDependency)entry.getValue();
            SourceIdentifier sourceIdentifier = (SourceIdentifier)entry.getKey();
            if (this.isKnown(resolved, belongs)) continue;
            LOG.debug("Source {} is missing parent {}", (Object)sourceIdentifier, (Object)belongs);
            pending.add(sourceIdentifier);
            resolved.remove(sourceIdentifier);
        }
        ArrayListMultimap imports = ArrayListMultimap.create();
        for (SourceIdentifier id : pending) {
            YangModelDependencyInfo dep = depInfo.get(id);
            for (ModuleImport mi : dep.getDependencies()) {
                if (this.isKnown(pending, mi) || this.isKnown(resolved, mi)) continue;
                imports.put((Object)id, (Object)mi);
            }
        }
        this.resolvedSources = ImmutableList.copyOf(resolved);
        this.unresolvedSources = ImmutableList.copyOf(pending);
        this.unsatisfiedImports = ImmutableMultimap.copyOf((Multimap)imports);
    }

    protected abstract boolean isKnown(Collection<SourceIdentifier> var1, ModuleImport var2);

    Collection<SourceIdentifier> getResolvedSources() {
        return this.resolvedSources;
    }

    Collection<SourceIdentifier> getUnresolvedSources() {
        return this.unresolvedSources;
    }

    Multimap<SourceIdentifier, ModuleImport> getUnsatisfiedImports() {
        return this.unsatisfiedImports;
    }

    private static class BelongsToDependency
    implements ModuleImport {
        private final String parent;

        BelongsToDependency(String parent) {
            this.parent = parent;
        }

        public String getModuleName() {
            return this.parent;
        }

        public Optional<Revision> getRevision() {
            return Optional.empty();
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getReference() {
            return Optional.empty();
        }

        public String getPrefix() {
            return null;
        }

        public Optional<SemVer> getSemanticVersion() {
            return Optional.empty();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("parent", (Object)this.parent).toString();
        }

        public ImportEffectiveStatement asEffectiveStatement() {
            throw new UnsupportedOperationException();
        }
    }
}

