/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;

final class SemVerDependencyResolver
extends DependencyResolver {
    protected SemVerDependencyResolver(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        super(depInfo);
    }

    protected static SourceIdentifier findCompatibleVersion(Iterable<SourceIdentifier> haystack, ModuleImport mi) {
        String requestedModuleName = mi.getModuleName();
        for (SourceIdentifier r : haystack) {
            if (!requestedModuleName.equals(r.getName()) || !SemVerDependencyResolver.isCompatible(((SemVerSourceIdentifier)r).getSemanticVersion(), mi.getSemanticVersion())) continue;
            return r;
        }
        return null;
    }

    private static boolean isCompatible(Optional<SemVer> moduleSemVer, Optional<SemVer> importSemVer) {
        if (importSemVer.isEmpty()) {
            return true;
        }
        if (moduleSemVer.isEmpty()) {
            return false;
        }
        SemVer modVer = moduleSemVer.get();
        SemVer impVer = importSemVer.get();
        return modVer.getMajor() == impVer.getMajor() && modVer.compareTo(impVer) >= 0;
    }

    @Override
    protected boolean isKnown(Collection<SourceIdentifier> haystack, ModuleImport mi) {
        SemVerSourceIdentifier msi = SemVerSourceIdentifier.create((String)mi.getModuleName(), (Optional)mi.getRevision(), (SemVer)mi.getSemanticVersion().orElse(null));
        if (haystack.contains(msi)) {
            return true;
        }
        return SemVerDependencyResolver.findCompatibleVersion(haystack, mi) != null;
    }

    public static SemVerDependencyResolver create(Map<SourceIdentifier, YangModelDependencyInfo> depInfo) {
        return new SemVerDependencyResolver(depInfo);
    }
}

