/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.yangtools.concepts.AbstractIdentifiable;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.parser.api.YangParser;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserException;
import org.opendaylight.yangtools.yang.model.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.EffectiveModelContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaResolutionException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceRepresentation;
import org.opendaylight.yangtools.yang.model.repo.api.SemVerSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;
import org.opendaylight.yangtools.yang.parser.repo.DependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.RevisionDependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.SemVerDependencyResolver;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRSchemaSource;
import org.opendaylight.yangtools.yang.parser.rfc7950.ir.IRStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangModelDependencyInfo;
import org.opendaylight.yangtools.yang.parser.spi.meta.ReactorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SharedSchemaContextFactory
implements EffectiveModelContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SharedSchemaContextFactory.class);
    private final Cache<Collection<SourceIdentifier>, EffectiveModelContext> revisionCache = CacheBuilder.newBuilder().weakValues().build();
    private final Cache<Collection<SourceIdentifier>, EffectiveModelContext> semVerCache = CacheBuilder.newBuilder().weakValues().build();
    private final @NonNull SharedSchemaRepository repository;
    private final @NonNull SchemaContextFactoryConfiguration config;

    SharedSchemaContextFactory(@NonNull SharedSchemaRepository repository, @NonNull SchemaContextFactoryConfiguration config) {
        this.repository = Objects.requireNonNull(repository);
        this.config = Objects.requireNonNull(config);
    }

    public @NonNull ListenableFuture<EffectiveModelContext> createEffectiveModelContext(@NonNull Collection<SourceIdentifier> requiredSources) {
        return this.createSchemaContext(requiredSources, this.config.getStatementParserMode() == StatementParserMode.SEMVER_MODE ? this.semVerCache : this.revisionCache, new AssembleSources(this.repository.factory(), this.config));
    }

    private @NonNull ListenableFuture<EffectiveModelContext> createSchemaContext(Collection<SourceIdentifier> requiredSources, final Cache<Collection<SourceIdentifier>, EffectiveModelContext> cache, AsyncFunction<List<IRSchemaSource>, EffectiveModelContext> assembleSources) {
        final List<SourceIdentifier> uniqueSourceIdentifiers = SharedSchemaContextFactory.deDuplicateSources(requiredSources);
        EffectiveModelContext existing = (EffectiveModelContext)cache.getIfPresent(uniqueSourceIdentifiers);
        if (existing != null) {
            LOG.debug("Returning cached context {}", (Object)existing);
            return FluentFutures.immediateFluentFuture((Object)existing);
        }
        ListenableFuture sf = Futures.allAsList((Iterable)Collections2.transform(uniqueSourceIdentifiers, this::requestSource));
        sf = Futures.transform((ListenableFuture)sf, (Function)new SourceIdMismatchDetector(uniqueSourceIdentifiers), (Executor)MoreExecutors.directExecutor());
        ListenableFuture cf = Futures.transformAsync((ListenableFuture)sf, assembleSources, (Executor)MoreExecutors.directExecutor());
        final SettableFuture rf = SettableFuture.create();
        Futures.addCallback((ListenableFuture)cf, (FutureCallback)new FutureCallback<EffectiveModelContext>(){

            public void onSuccess(EffectiveModelContext result) {
                EffectiveModelContext existing;
                try {
                    existing = (EffectiveModelContext)cache.get((Object)uniqueSourceIdentifiers, () -> result);
                }
                catch (ExecutionException e) {
                    LOG.warn("Failed to recheck result with cache, will use computed value", (Throwable)e);
                    rf.set((Object)result);
                    return;
                }
                rf.set((Object)existing);
            }

            public void onFailure(Throwable cause) {
                LOG.debug("Failed to assemble sources", cause);
                rf.setException(cause);
            }
        }, (Executor)MoreExecutors.directExecutor());
        return rf;
    }

    private ListenableFuture<IRSchemaSource> requestSource(@NonNull SourceIdentifier identifier) {
        return this.repository.getSchemaSource(identifier, IRSchemaSource.class);
    }

    private static List<SourceIdentifier> deDuplicateSources(Collection<SourceIdentifier> requiredSources) {
        LinkedHashSet<SourceIdentifier> uniqueSourceIdentifiers = new LinkedHashSet<SourceIdentifier>(requiredSources);
        if (uniqueSourceIdentifiers.size() == requiredSources.size()) {
            return ImmutableList.copyOf(requiredSources);
        }
        LOG.warn("Duplicate sources requested for schema context, removed duplicate sources: {}", (Object)Collections2.filter(uniqueSourceIdentifiers, input -> Iterables.frequency((Iterable)requiredSources, (Object)input) > 1));
        return ImmutableList.copyOf(uniqueSourceIdentifiers);
    }

    private static final class AssembleSources
    implements AsyncFunction<List<IRSchemaSource>, EffectiveModelContext> {
        private final @NonNull YangParserFactory parserFactory;
        private final @NonNull SchemaContextFactoryConfiguration config;
        private final @NonNull Function<IRSchemaSource, SourceIdentifier> getIdentifier;

        private AssembleSources(@NonNull YangParserFactory parserFactory, @NonNull SchemaContextFactoryConfiguration config) {
            this.parserFactory = parserFactory;
            this.config = config;
            switch (config.getStatementParserMode()) {
                case SEMVER_MODE: {
                    this.getIdentifier = AssembleSources::getSemVerIdentifier;
                    break;
                }
                default: {
                    this.getIdentifier = AbstractIdentifiable::getIdentifier;
                }
            }
        }

        public FluentFuture<EffectiveModelContext> apply(List<IRSchemaSource> sources) throws SchemaResolutionException, ReactorException {
            EffectiveModelContext schemaContext;
            DependencyResolver res;
            ImmutableMap srcs = Maps.uniqueIndex(sources, this.getIdentifier);
            Map deps = Maps.transformValues((Map)srcs, YangModelDependencyInfo::forIR);
            LOG.debug("Resolving dependency reactor {}", (Object)deps);
            StatementParserMode statementParserMode = this.config.getStatementParserMode();
            DependencyResolver dependencyResolver = res = statementParserMode == StatementParserMode.SEMVER_MODE ? SemVerDependencyResolver.create(deps) : RevisionDependencyResolver.create(deps);
            if (!res.getUnresolvedSources().isEmpty()) {
                LOG.debug("Omitting models {} due to unsatisfied imports {}", res.getUnresolvedSources(), res.getUnsatisfiedImports());
                throw new SchemaResolutionException("Failed to resolve required models", res.getResolvedSources(), res.getUnsatisfiedImports());
            }
            YangParser parser = this.parserFactory.createParser(statementParserMode);
            this.config.getSupportedFeatures().ifPresent(arg_0 -> ((YangParser)parser).setSupportedFeatures(arg_0));
            this.config.getModulesDeviatedByModules().ifPresent(arg_0 -> ((YangParser)parser).setModulesWithSupportedDeviations(arg_0));
            for (Map.Entry entry : srcs.entrySet()) {
                try {
                    parser.addSource((SchemaSourceRepresentation)entry.getValue());
                }
                catch (IOException | YangSyntaxErrorException e) {
                    throw new SchemaResolutionException("Failed to add source " + entry.getKey(), e);
                }
            }
            try {
                schemaContext = parser.buildEffectiveModel();
            }
            catch (YangParserException e) {
                throw new SchemaResolutionException("Failed to resolve required models", (Throwable)e);
            }
            return FluentFutures.immediateFluentFuture((Object)schemaContext);
        }

        private static SemVerSourceIdentifier getSemVerIdentifier(IRSchemaSource source) {
            SourceIdentifier identifier = (SourceIdentifier)source.getIdentifier();
            SemVer semver = YangModelDependencyInfo.findSemanticVersion((IRStatement)source.getRootStatement(), (SourceIdentifier)identifier);
            if (identifier instanceof SemVerSourceIdentifier && semver == null) {
                return (SemVerSourceIdentifier)identifier;
            }
            return SemVerSourceIdentifier.create((String)identifier.getName(), (Optional)identifier.getRevision(), (SemVer)semver);
        }
    }

    @SuppressModernizer
    private static final class SourceIdMismatchDetector
    implements Function<List<IRSchemaSource>, List<IRSchemaSource>> {
        private final List<SourceIdentifier> sourceIdentifiers;

        SourceIdMismatchDetector(List<SourceIdentifier> sourceIdentifiers) {
            this.sourceIdentifiers = Objects.requireNonNull(sourceIdentifiers);
        }

        public List<IRSchemaSource> apply(List<IRSchemaSource> input) {
            LinkedHashMap<SourceIdentifier, IRSchemaSource> filtered = new LinkedHashMap<SourceIdentifier, IRSchemaSource>();
            for (int i = 0; i < input.size(); ++i) {
                IRSchemaSource irSchemaSource;
                SourceIdentifier realSId;
                SourceIdentifier expectedSId = this.sourceIdentifiers.get(i);
                if (!expectedSId.equals(realSId = (SourceIdentifier)(irSchemaSource = input.get(i)).getIdentifier())) {
                    LOG.warn("Source identifier mismatch for module \"{}\", requested as {} but actually is {}. Using actual id", new Object[]{expectedSId.getName(), expectedSId, realSId});
                }
                if (filtered.containsKey(realSId)) {
                    LOG.warn("Duplicate source for module {} detected in reactor", (Object)realSId);
                }
                filtered.put(realSId, irSchemaSource);
            }
            return ImmutableList.copyOf(filtered.values());
        }
    }
}

