/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import java.io.DataInput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.ConnectClientRequest;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestProxy;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;

final class ConnectClientRequestProxyV1
extends AbstractRequestProxy<ClientIdentifier, ConnectClientRequest> {
    private ABIVersion minVersion;
    private ABIVersion maxVersion;

    public ConnectClientRequestProxyV1() {
    }

    ConnectClientRequestProxyV1(ConnectClientRequest request) {
        super(request);
        this.minVersion = request.getMinVersion();
        this.maxVersion = request.getMaxVersion();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.minVersion.writeTo(out);
        this.maxVersion.writeTo(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.minVersion = ABIVersion.inexactReadFrom(in);
        this.maxVersion = ABIVersion.inexactReadFrom(in);
    }

    @Override
    protected ConnectClientRequest createRequest(ClientIdentifier target, long sequence, ActorRef replyTo) {
        return new ConnectClientRequest(target, sequence, replyTo, this.minVersion, this.maxVersion);
    }

    @Override
    protected ClientIdentifier readTarget(DataInput in) throws IOException {
        return ClientIdentifier.readFrom(in);
    }
}

