/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequestProxyV1;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;

public final class IncrementTransactionSequenceRequest
extends AbstractReadTransactionRequest<IncrementTransactionSequenceRequest> {
    private static final long serialVersionUID = 1L;
    private final long increment;

    public IncrementTransactionSequenceRequest(TransactionIdentifier identifier, long sequence, ActorRef replyTo, boolean snapshotOnly, long increment) {
        super(identifier, sequence, replyTo, snapshotOnly);
        Preconditions.checkArgument((increment >= 0L ? 1 : 0) != 0);
        this.increment = increment;
    }

    public long getIncrement() {
        return this.increment;
    }

    @Override
    protected IncrementTransactionSequenceRequestProxyV1 externalizableProxy(ABIVersion version) {
        return new IncrementTransactionSequenceRequestProxyV1(this);
    }

    @Override
    protected IncrementTransactionSequenceRequest cloneAsVersion(ABIVersion targetVersion) {
        return this;
    }
}

