/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import akka.actor.ActorRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.commands.AbstractReadTransactionRequestProxyV1;
import org.opendaylight.controller.cluster.access.commands.IncrementTransactionSequenceRequest;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.concepts.WritableObjects;

final class IncrementTransactionSequenceRequestProxyV1
extends AbstractReadTransactionRequestProxyV1<IncrementTransactionSequenceRequest> {
    private long increment;

    public IncrementTransactionSequenceRequestProxyV1() {
    }

    IncrementTransactionSequenceRequestProxyV1(IncrementTransactionSequenceRequest request) {
        super(request);
        this.increment = request.getIncrement();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        WritableObjects.writeLong((DataOutput)out, (long)this.increment);
    }

    @Override
    public void readExternal(ObjectInput in) throws ClassNotFoundException, IOException {
        super.readExternal(in);
        this.increment = WritableObjects.readLong((DataInput)in);
    }

    @Override
    IncrementTransactionSequenceRequest createReadRequest(TransactionIdentifier target, long sequence, ActorRef replyToActor, boolean snapshotOnly) {
        return new IncrementTransactionSequenceRequest(target, sequence, replyToActor, snapshotOnly, this.increment);
    }
}

