/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.commands;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.commands.AbstractTransactionSuccessProxy;
import org.opendaylight.controller.cluster.access.commands.ReadTransactionSuccess;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;

final class ReadTransactionSuccessProxyV1
extends AbstractTransactionSuccessProxy<ReadTransactionSuccess> {
    private static final long serialVersionUID = 1L;
    private Optional<NormalizedNode<?, ?>> data;
    private transient NormalizedNodeStreamVersion streamVersion;

    public ReadTransactionSuccessProxyV1() {
    }

    ReadTransactionSuccessProxyV1(ReadTransactionSuccess request) {
        super(request);
        this.data = request.getData();
        this.streamVersion = request.getVersion().getStreamVersion();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.data.isPresent()) {
            out.writeBoolean(true);
            try (NormalizedNodeDataOutput nnout = this.streamVersion.newDataOutput((DataOutput)out);){
                nnout.writeNormalizedNode(this.data.get());
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.data = in.readBoolean() ? Optional.of(NormalizedNodeDataInput.newDataInput((DataInput)in).readNormalizedNode()) : Optional.empty();
    }

    @Override
    protected ReadTransactionSuccess createSuccess(TransactionIdentifier target, long sequence) {
        return new ReadTransactionSuccess(target, sequence, this.data);
    }
}

