/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.opendaylight.controller.cluster.access.concepts.AbstractEnvelopeProxy;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.yangtools.concepts.WritableObjects;

abstract class AbstractResponseEnvelopeProxy<T extends Response<?, ?>>
extends AbstractEnvelopeProxy<T> {
    private static final long serialVersionUID = 1L;
    private long executionTimeNanos;

    AbstractResponseEnvelopeProxy() {
    }

    AbstractResponseEnvelopeProxy(ResponseEnvelope<T> envelope) {
        super(envelope);
        this.executionTimeNanos = envelope.getExecutionTimeNanos();
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        WritableObjects.writeLong((DataOutput)out, (long)this.executionTimeNanos);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.executionTimeNanos = WritableObjects.readLong((DataInput)in);
    }

    @Override
    final ResponseEnvelope<T> createEnvelope(T message, long sessionId, long txSequence) {
        return this.createEnvelope(message, sessionId, txSequence, this.executionTimeNanos);
    }

    abstract ResponseEnvelope<T> createEnvelope(T var1, long var2, long var4, long var6);
}

