/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.concepts.AbstractRequestFailureProxy;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.yangtools.concepts.WritableIdentifier;

@Beta
public abstract class RequestFailure<T extends WritableIdentifier, C extends RequestFailure<T, C>>
extends Response<T, C> {
    private static final long serialVersionUID = 1L;
    private final @NonNull RequestException cause;

    protected RequestFailure(@NonNull C failure, @NonNull ABIVersion version) {
        super(failure, version);
        this.cause = Objects.requireNonNull(((RequestFailure)failure).getCause());
    }

    protected RequestFailure(@NonNull T target, long sequence, @NonNull RequestException cause) {
        super(target, sequence);
        this.cause = Objects.requireNonNull(cause);
    }

    public final @NonNull RequestException getCause() {
        return this.cause;
    }

    public final boolean isHardFailure() {
        return !this.cause.isRetriable();
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("cause", (Object)this.cause);
    }

    @Override
    protected abstract AbstractRequestFailureProxy<T, C> externalizableProxy(ABIVersion var1);
}

