/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonService;
import org.opendaylight.mdsal.singleton.common.api.ClusterSingletonServiceProvider;
import org.opendaylight.mdsal.singleton.common.api.ServiceGroupIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.controller.basic.rpc.test.rev160120.BasicGlobalInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.controller.basic.rpc.test.rev160120.BasicGlobalOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.controller.basic.rpc.test.rev160120.BasicGlobalOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.controller.basic.rpc.test.rev160120.BasicRpcTestService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRpcTestProvider
implements ClusterSingletonService,
BasicRpcTestService {
    private static final Logger LOG = LoggerFactory.getLogger(BasicRpcTestProvider.class);
    private static final ServiceGroupIdentifier IDENTIFIER = ServiceGroupIdentifier.create((String)"Basic-rpc-test");
    private final RpcProviderService rpcProviderRegistry;
    private final ClusterSingletonServiceProvider singletonService;
    private ObjectRegistration<?> rpcRegistration;

    public BasicRpcTestProvider(RpcProviderService rpcProviderRegistry, ClusterSingletonServiceProvider singletonService) {
        this.rpcProviderRegistry = rpcProviderRegistry;
        this.singletonService = singletonService;
        singletonService.registerClusterSingletonService((ClusterSingletonService)this);
    }

    public void instantiateServiceInstance() {
        LOG.info("Basic testing rpc registered as global");
        this.rpcRegistration = this.rpcProviderRegistry.registerRpcImplementation(BasicRpcTestService.class, (RpcService)this);
    }

    public ListenableFuture<Void> closeServiceInstance() {
        this.rpcRegistration.close();
        this.rpcRegistration = null;
        return Futures.immediateFuture(null);
    }

    public ServiceGroupIdentifier getIdentifier() {
        return IDENTIFIER;
    }

    public ListenableFuture<RpcResult<BasicGlobalOutput>> basicGlobal(BasicGlobalInput input) {
        LOG.info("Basic test global rpc invoked");
        return Futures.immediateFuture((Object)RpcResultBuilder.success((Object)new BasicGlobalOutputBuilder().build()).build());
    }
}

