/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.car.purchase.rev140818.CarPurchaseService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.AddPersonInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.AddPersonOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.AddPersonOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.People;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.PeopleService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.Person;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.people.PersonBuilder;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeopleProvider
implements PeopleService,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PeopleProvider.class);
    private final Set<ObjectRegistration<?>> regs = new HashSet();
    private final DataBroker dataProvider;
    private final RpcProviderService rpcProviderService;
    private final CarPurchaseService rpcImplementation;

    public PeopleProvider(DataBroker dataProvider, RpcProviderService rpcProviderService, CarPurchaseService rpcImplementation) {
        this.dataProvider = Objects.requireNonNull(dataProvider);
        this.rpcProviderService = Objects.requireNonNull(rpcProviderService);
        this.rpcImplementation = Objects.requireNonNull(rpcImplementation);
        this.regs.add(rpcProviderService.registerRpcImplementation(CarPurchaseService.class, (RpcService)rpcImplementation));
    }

    public ListenableFuture<RpcResult<AddPersonOutput>> addPerson(AddPersonInput input) {
        LOG.info("RPC addPerson : adding person [{}]", (Object)input);
        PersonBuilder builder = new PersonBuilder((Person)input);
        final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.people.Person person = builder.build();
        final SettableFuture futureResult = SettableFuture.create();
        final InstanceIdentifier personId = InstanceIdentifier.builder(People.class).child(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.sal.clustering.it.people.rev140818.people.Person.class, (Identifier)person.key()).build();
        WriteTransaction tx = this.dataProvider.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.CONFIGURATION, personId, (DataObject)person);
        tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onSuccess(CommitInfo result) {
                LOG.info("RPC addPerson : person added successfully [{}]", (Object)person);
                PeopleProvider.this.regs.add(PeopleProvider.this.rpcProviderService.registerRpcImplementation(CarPurchaseService.class, (RpcService)PeopleProvider.this.rpcImplementation, (Set)ImmutableSet.of((Object)personId)));
                LOG.info("RPC addPerson : routed rpc registered for instance ID [{}]", (Object)personId);
                futureResult.set((Object)RpcResultBuilder.success((Object)new AddPersonOutputBuilder().build()).build());
            }

            public void onFailure(Throwable ex) {
                LOG.error("RPC addPerson : person addition failed [{}]", (Object)person, (Object)ex);
                futureResult.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, ex.getMessage()).build());
            }
        }, MoreExecutors.directExecutor());
        return futureResult;
    }

    @Override
    public void close() {
        this.regs.forEach(Registration::close);
        this.regs.clear();
    }
}

