/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListeningException;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class IdIntsDOMDataTreeLIstener
implements DOMDataTreeListener {
    private static final Logger LOG = LoggerFactory.getLogger(IdIntsDOMDataTreeLIstener.class);
    private static final long SECOND_AS_NANO = 1000000000L;
    private NormalizedNode<?, ?> localCopy = null;
    private final AtomicLong lastNotifTimestamp = new AtomicLong(0L);
    private ScheduledFuture<?> scheduledFuture;
    private ScheduledExecutorService executorService;

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees) {
        Preconditions.checkState((changes.size() == 1 ? 1 : 0) != 0);
        this.lastNotifTimestamp.set(System.nanoTime());
        LOG.debug("Received data tree changed");
        changes.forEach(change -> {
            if (change.getRootNode().getDataAfter().isPresent()) {
                LOG.trace("Received change, data before: {}, data after: {}", change.getRootNode().getDataBefore().isPresent() ? change.getRootNode().getDataBefore().get() : "", change.getRootNode().getDataAfter().get());
                if (this.localCopy == null || this.checkEqual((NormalizedNode)change.getRootNode().getDataBefore().get())) {
                    this.localCopy = (NormalizedNode)change.getRootNode().getDataAfter().get();
                } else {
                    LOG.warn("Ignoring notification.");
                    LOG.trace("Ignored notification content: {}", change);
                }
            } else {
                LOG.warn("getDataAfter() is missing from notification. change: {}", change);
            }
        });
    }

    public void onDataTreeFailed(Collection<DOMDataTreeListeningException> causes) {
    }

    public boolean hasTriggered() {
        return this.localCopy != null;
    }

    public Future<Void> tryFinishProcessing() {
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        SettableFuture settableFuture = SettableFuture.create();
        this.scheduledFuture = this.executorService.scheduleAtFixedRate(new CheckFinishedTask((SettableFuture<Void>)settableFuture), 0L, 1L, TimeUnit.SECONDS);
        return settableFuture;
    }

    public boolean checkEqual(NormalizedNode<?, ?> expected) {
        return this.localCopy.equals(expected);
    }

    private class CheckFinishedTask
    implements Runnable {
        private final SettableFuture<Void> future;

        CheckFinishedTask(SettableFuture<Void> future) {
            this.future = future;
        }

        @Override
        public void run() {
            if (System.nanoTime() - IdIntsDOMDataTreeLIstener.this.lastNotifTimestamp.get() > 4000000000L) {
                IdIntsDOMDataTreeLIstener.this.scheduledFuture.cancel(false);
                this.future.set(null);
                IdIntsDOMDataTreeLIstener.this.executorService.shutdown();
            }
        }
    }
}

