/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.sharding.DistributedShardFactory;
import org.opendaylight.controller.cluster.sharding.DistributedShardRegistration;
import org.opendaylight.controller.clustering.it.provider.impl.AbstractTransactionHandler;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeShardingConflictException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CreatePrefixShardInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CreatePrefixShardOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.CreatePrefixShardOutputBuilder;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemovePrefixShardInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemovePrefixShardOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.RemovePrefixShardOutputBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(forRemoval=true)
public class PrefixShardHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixShardHandler.class);
    private static final int MAX_PREFIX = 4;
    private static final String PREFIX_TEMPLATE = "prefix-";
    private final DistributedShardFactory shardFactory;
    private final DOMDataTreeService domDataTreeService;
    private final BindingNormalizedNodeSerializer serializer;
    private final Map<YangInstanceIdentifier, DistributedShardRegistration> registrations = Collections.synchronizedMap(new HashMap());

    public PrefixShardHandler(DistributedShardFactory shardFactory, DOMDataTreeService domDataTreeService, BindingNormalizedNodeSerializer serializer) {
        this.shardFactory = shardFactory;
        this.domDataTreeService = domDataTreeService;
        this.serializer = serializer;
    }

    public ListenableFuture<RpcResult<CreatePrefixShardOutput>> onCreatePrefixShard(CreatePrefixShardInput input) {
        final SettableFuture future = SettableFuture.create();
        final YangInstanceIdentifier identifier = this.serializer.toYangInstanceIdentifier(input.getPrefix());
        try {
            CompletionStage completionStage = this.shardFactory.createDistributedShard(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, identifier), (Collection)input.getReplicas().stream().map(MemberName::forName).collect(Collectors.toList()));
            completionStage.thenAccept(registration -> {
                LOG.debug("Shard[{}] created successfully.", (Object)identifier);
                this.registrations.put(identifier, (DistributedShardRegistration)registration);
                ListenableFuture<?> ensureFuture = this.ensureListExists();
                Futures.addCallback(ensureFuture, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(Object result) {
                        LOG.debug("Initial list write successful.");
                        future.set((Object)RpcResultBuilder.success((Object)new CreatePrefixShardOutputBuilder().build()).build());
                    }

                    public void onFailure(Throwable throwable) {
                        LOG.warn("Shard[{}] creation failed:", (Object)identifier, (Object)throwable);
                        RpcError error = RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"create-shard-failed", (String)"Shard creation failed", (String)"cluster-test-app", (String)"", (Throwable)throwable);
                        future.set((Object)RpcResultBuilder.failed().withRpcError(error).build());
                    }
                }, (Executor)MoreExecutors.directExecutor());
            });
            completionStage.exceptionally(throwable -> {
                LOG.warn("Shard[{}] creation failed:", (Object)identifier, throwable);
                RpcError error = RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"create-shard-failed", (String)"Shard creation failed", (String)"cluster-test-app", (String)"", (Throwable)throwable);
                future.set((Object)RpcResultBuilder.failed().withRpcError(error).build());
                return null;
            });
        }
        catch (DOMDataTreeShardingConflictException e) {
            LOG.warn("Unable to register shard for: {}.", (Object)identifier);
            RpcError error = RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"create-shard-failed", (String)"Sharding conflict", (String)"cluster-test-app", (String)"", (Throwable)e);
            future.set((Object)RpcResultBuilder.failed().withRpcError(error).build());
        }
        return future;
    }

    public ListenableFuture<RpcResult<RemovePrefixShardOutput>> onRemovePrefixShard(RemovePrefixShardInput input) {
        YangInstanceIdentifier identifier = this.serializer.toYangInstanceIdentifier(input.getPrefix());
        DistributedShardRegistration registration = this.registrations.get(identifier);
        if (registration == null) {
            RpcError error = RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"registration-missing", (String)"No shard registered at this prefix.");
            return Futures.immediateFuture((Object)RpcResultBuilder.failed().withRpcError(error).build());
        }
        SettableFuture future = SettableFuture.create();
        CompletionStage close = registration.close();
        close.thenRun(() -> future.set((Object)RpcResultBuilder.success((Object)new RemovePrefixShardOutputBuilder().build()).build()));
        close.exceptionally(throwable -> {
            LOG.warn("Shard[{}] removal failed:", (Object)identifier, throwable);
            RpcError error = RpcResultBuilder.newError((RpcError.ErrorType)RpcError.ErrorType.APPLICATION, (String)"remove-shard-failed", (String)"Shard removal failed", (String)"cluster-test-app", (String)"", (Throwable)throwable);
            future.set((Object)RpcResultBuilder.failed().withRpcError(error).build());
            return null;
        });
        return future;
    }

    private ListenableFuture<?> ensureListExists() {
        CollectionNodeBuilder mapBuilder = ImmutableNodes.mapNodeBuilder((QName)AbstractTransactionHandler.ID_INT);
        for (int i = 1; i < 4; ++i) {
            mapBuilder.withChild((NormalizedNode)((MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)AbstractTransactionHandler.ID_INT, (QName)AbstractTransactionHandler.ID, (Object)(PREFIX_TEMPLATE + i)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)AbstractTransactionHandler.ITEM).build()).build()));
        }
        MapNode mapNode = (MapNode)mapBuilder.build();
        ContainerNode containerNode = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(AbstractTransactionHandler.ID_INTS)).withChild((DataContainerChild)mapNode).build();
        final DOMDataTreeProducer producer = this.domDataTreeService.createProducer(Collections.singleton(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty())));
        DOMDataTreeCursorAwareTransaction tx = producer.createTransaction(false);
        DOMDataTreeWriteCursor cursor = tx.createCursor(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, YangInstanceIdentifier.empty()));
        cursor.merge(containerNode.getIdentifier(), (NormalizedNode)containerNode);
        cursor.close();
        FluentFuture future = tx.commit();
        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(Object result) {
                try {
                    LOG.debug("Closing producer for initial list.");
                    producer.close();
                }
                catch (DOMDataTreeProducerException e) {
                    LOG.warn("Error while closing producer.", (Throwable)e);
                }
            }

            public void onFailure(Throwable throwable) {
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }
}

