/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.it.provider.impl;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.clustering.it.provider.impl.AbstractTransactionHandler;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.TransactionsParams;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsInput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsOutput;
import org.opendaylight.yang.gen.v1.tag.opendaylight.org._2017.controller.yang.lowlevel.control.rev170215.WriteTransactionsOutputBuilder;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.api.CollectionNodeBuilder;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WriteTransactionsHandler
extends AbstractTransactionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WriteTransactionsHandler.class);
    final SettableFuture<RpcResult<WriteTransactionsOutput>> completionFuture = SettableFuture.create();
    private final Set<Integer> usedValues = ConcurrentHashMap.newKeySet();
    private final YangInstanceIdentifier idListItem;
    private final AtomicLong insertTx = new AtomicLong();
    private final AtomicLong deleteTx = new AtomicLong();

    WriteTransactionsHandler(YangInstanceIdentifier idListItem, WriteTransactionsInput input) {
        super((TransactionsParams)input);
        this.idListItem = Objects.requireNonNull(idListItem);
    }

    public static ListenableFuture<RpcResult<WriteTransactionsOutput>> start(DOMDataBroker domDataBroker, WriteTransactionsInput input) {
        LOG.info("Starting write transactions with input {}", (Object)input);
        String id = input.getId();
        MapEntryNode entry = (MapEntryNode)ImmutableNodes.mapEntryBuilder((QName)ID_INT, (QName)ID, (Object)id).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)ITEM).build()).build();
        YangInstanceIdentifier idListItem = ID_INT_YID.node((YangInstanceIdentifier.PathArgument)entry.getIdentifier());
        ContainerNode containerNode = (ContainerNode)ImmutableContainerNodeBuilder.create().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(ID_INTS)).withChild((DataContainerChild)ImmutableNodes.mapNodeBuilder((QName)ID_INT).build()).build();
        DOMDataTreeWriteTransaction tx = domDataBroker.newWriteOnlyTransaction();
        tx.merge(LogicalDatastoreType.CONFIGURATION, ID_INTS_YID, (NormalizedNode)containerNode);
        try {
            tx.commit().get(125L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            LOG.error("Error writing top-level path {}: {}", new Object[]{ID_INTS_YID, containerNode, e});
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, String.format("Could not start write transactions - error writing top-level path %s:  %s", ID_INTS_YID, containerNode), (Throwable)e).buildFuture();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OptimisticLockFailedException) {
                LOG.debug("Got an optimistic lock when writing initial top level list element.", (Throwable)e);
            }
            LOG.error("Error writing top-level path {}: {}", new Object[]{ID_INTS_YID, containerNode, e});
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, String.format("Could not start write transactions - error writing top-level path %s:  %s", ID_INTS_YID, containerNode), (Throwable)e).buildFuture();
        }
        tx = domDataBroker.newWriteOnlyTransaction();
        tx.merge(LogicalDatastoreType.CONFIGURATION, idListItem, (NormalizedNode)entry);
        try {
            tx.commit().get(125L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Error writing top-level path {}: {}", new Object[]{idListItem, entry, e});
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, String.format("Could not start write transactions - error writing list entry path %s: %s", idListItem, entry), (Throwable)e).buildFuture();
        }
        LOG.debug("Filling the item list with initial values.");
        CollectionNodeBuilder mapBuilder = ImmutableNodes.mapNodeBuilder((QName)ITEM);
        YangInstanceIdentifier itemListId = idListItem.node(ITEM);
        tx = domDataBroker.newWriteOnlyTransaction();
        MapNode itemListNode = (MapNode)mapBuilder.build();
        tx.put(LogicalDatastoreType.CONFIGURATION, itemListId, (NormalizedNode)itemListNode);
        try {
            tx.commit().get(125L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Error filling initial item list path {}: {}", new Object[]{itemListId, itemListNode, e});
            return RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, String.format("Could not start write transactions - error filling initial item list path %s: %s", itemListId, itemListNode), (Throwable)e).buildFuture();
        }
        WriteTransactionsHandler handler = input.getChainedTransactions() != false ? new Chained(domDataBroker, idListItem, input) : new Simple(domDataBroker, idListItem, input);
        handler.doStart();
        LOG.info("Write transactions successfully started");
        return handler.completionFuture;
    }

    @Override
    FluentFuture<? extends @NonNull CommitInfo> execWrite(long txId) {
        int i = this.nextInt(0x100001);
        YangInstanceIdentifier entryId = this.idListItem.node(ITEM).node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)ITEM, (QName)NUMBER, (Object)i));
        DOMDataTreeWriteTransaction tx = this.createTransaction();
        if (this.usedValues.contains(i)) {
            LOG.debug("Deleting item: {}", (Object)i);
            this.deleteTx.incrementAndGet();
            tx.delete(LogicalDatastoreType.CONFIGURATION, entryId);
            this.usedValues.remove(i);
        } else {
            LOG.debug("Inserting item: {}", (Object)i);
            this.insertTx.incrementAndGet();
            MapEntryNode entry = ImmutableNodes.mapEntry((QName)ITEM, (QName)NUMBER, (Object)i);
            tx.put(LogicalDatastoreType.CONFIGURATION, entryId, (NormalizedNode)entry);
            this.usedValues.add(i);
        }
        return tx.commit();
    }

    @Override
    void runFailed(Throwable cause, long txId) {
        this.completionFuture.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, "Commit failed for tx # " + txId, cause).build());
    }

    @Override
    void runSuccessful(long allTx) {
        WriteTransactionsOutput output = new WriteTransactionsOutputBuilder().setAllTx(Long.valueOf(allTx)).setInsertTx(Long.valueOf(this.insertTx.get())).setDeleteTx(Long.valueOf(this.deleteTx.get())).build();
        this.completionFuture.set((Object)RpcResultBuilder.success().withResult((Object)output).build());
    }

    @Override
    void runTimedOut(String cause) {
        this.completionFuture.set((Object)RpcResultBuilder.failed().withError(RpcError.ErrorType.APPLICATION, cause).build());
    }

    abstract DOMDataTreeWriteTransaction createTransaction();

    abstract int nextInt(int var1);

    private static final class Simple
    extends WriteTransactionsHandler {
        private final LinkedHashSet<Integer> previousNumbers = new LinkedHashSet();
        private final SplittableRandom random = new SplittableRandom();
        private final DOMDataBroker dataBroker;

        Simple(DOMDataBroker dataBroker, YangInstanceIdentifier idListItem, WriteTransactionsInput input) {
            super(idListItem, input);
            this.dataBroker = Objects.requireNonNull(dataBroker);
        }

        @Override
        DOMDataTreeWriteTransaction createTransaction() {
            return this.dataBroker.newWriteOnlyTransaction();
        }

        @Override
        int nextInt(int bound) {
            int nextInt;
            while (this.previousNumbers.contains(nextInt = this.random.nextInt(bound))) {
            }
            if (this.previousNumbers.size() > 100000) {
                this.previousNumbers.iterator().remove();
            }
            this.previousNumbers.add(nextInt);
            return nextInt;
        }
    }

    private static final class Chained
    extends WriteTransactionsHandler
    implements DOMTransactionChainListener {
        private final SplittableRandom random = new SplittableRandom();
        private final DOMTransactionChain transactionChain;

        Chained(DOMDataBroker dataBroker, YangInstanceIdentifier idListItem, WriteTransactionsInput input) {
            super(idListItem, input);
            this.transactionChain = dataBroker.createTransactionChain((DOMTransactionChainListener)this);
        }

        @Override
        DOMDataTreeWriteTransaction createTransaction() {
            return this.transactionChain.newWriteOnlyTransaction();
        }

        @Override
        int nextInt(int bound) {
            return this.random.nextInt(bound);
        }

        public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
            LOG.debug("Transaction chain failed.", cause);
        }

        public void onTransactionChainSuccessful(DOMTransactionChain chain) {
            LOG.debug("Transaction chain closed successfully.");
        }
    }
}

