/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc7952.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationEffectiveStatement;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNodeAware;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementEquivalent;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

@Beta
public interface AnnotationSchemaNode
extends UnknownSchemaNode,
TypeAware,
EffectiveStatementEquivalent<AnnotationEffectiveStatement> {
    public static @NonNull Optional<AnnotationSchemaNode> find(SchemaContext context, QName qname) {
        if (context instanceof AnnotationSchemaNodeAware) {
            return ((AnnotationSchemaNodeAware)context).findAnnotation(qname);
        }
        return context.findModule(qname.getModule()).flatMap(module -> module.getUnknownSchemaNodes().stream().filter(AnnotationSchemaNode.class::isInstance).map(AnnotationSchemaNode.class::cast).filter(annotation -> qname.equals((Object)annotation.getQName())).findAny());
    }

    public static @NonNull Map<QName, AnnotationSchemaNode> findAll(SchemaContext context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Module module : context.getModules()) {
            for (UnknownSchemaNode node : module.getUnknownSchemaNodes()) {
                if (!(node instanceof AnnotationSchemaNode)) continue;
                builder.put((Object)node.getQName(), (Object)((AnnotationSchemaNode)node));
            }
        }
        return builder.build();
    }
}

