/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.source.ImplicitSubstatement;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementWriter;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementMap;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SubstatementContext;

abstract class AbstractResumedStatement<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementContextBase<A, D, E>
implements StatementWriter.ResumedStatement {
    private final @NonNull StatementSourceReference statementDeclSource;
    private final String rawArgument;
    private StatementMap substatements = StatementMap.empty();
    private @Nullable D declaredInstance;

    AbstractResumedStatement(AbstractResumedStatement<A, D, E> original) {
        super(original);
        this.statementDeclSource = original.statementDeclSource;
        this.rawArgument = original.rawArgument;
        this.substatements = original.substatements;
        this.declaredInstance = original.declaredInstance;
    }

    AbstractResumedStatement(StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument) {
        super(def);
        this.statementDeclSource = Objects.requireNonNull(ref);
        this.rawArgument = def.support().internArgument(rawArgument);
    }

    AbstractResumedStatement(StatementDefinitionContext<A, D, E> def, StatementSourceReference ref, String rawArgument, CopyType copyType) {
        super(def, CopyHistory.of((CopyType)copyType, (CopyHistory)CopyHistory.original()));
        this.statementDeclSource = Objects.requireNonNull(ref);
        this.rawArgument = rawArgument;
    }

    public final Optional<StmtContext<A, D, E>> getOriginalCtx() {
        return Optional.empty();
    }

    public final Optional<StmtContext<A, D, E>> getPreviousCopyCtx() {
        return Optional.empty();
    }

    public final StatementSourceReference getStatementSourceReference() {
        return this.statementDeclSource;
    }

    public final String rawStatementArgument() {
        return this.rawArgument;
    }

    @Override
    public Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements() {
        return this.substatements;
    }

    public final D buildDeclared() {
        D existing = this.declaredInstance;
        return existing != null ? existing : this.loadDeclared();
    }

    private @NonNull D loadDeclared() {
        ModelProcessingPhase phase = this.getCompletedPhase();
        Preconditions.checkState((phase == ModelProcessingPhase.FULL_DECLARATION || phase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Cannot build declared instance after phase %s", (Object)phase);
        this.declaredInstance = this.definition().getFactory().createDeclared((StmtContext)this);
        return this.declaredInstance;
    }

    public @NonNull StatementDefinition getDefinition() {
        return this.getPublicDefinition();
    }

    public @NonNull StatementSourceReference getSourceReference() {
        return this.getStatementSourceReference();
    }

    public boolean isFullyDefined() {
        return this.fullyDefined();
    }

    final <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> AbstractResumedStatement<X, Y, Z> createSubstatement(int offset, StatementDefinitionContext<X, Y, Z> def, StatementSourceReference ref, String argument) {
        ModelProcessingPhase inProgressPhase = this.getRoot().getSourceContext().getInProgressPhase();
        Preconditions.checkState((inProgressPhase != ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Declared statement cannot be added in effective phase at: %s", (Object)this.getStatementSourceReference());
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition().getImplicitParentFor(def.getPublicView());
        if (implicitParent.isPresent()) {
            return this.createImplicitParent(offset, implicitParent.get(), ref, argument).createSubstatement(offset, def, ref, argument);
        }
        SubstatementContext<X, Y, Z> ret = new SubstatementContext<X, Y, Z>(this, def, ref, argument);
        this.substatements = this.substatements.put(offset, ret);
        def.onStatementAdded(ret);
        return ret;
    }

    @Override
    final boolean hasEmptySubstatements() {
        return this.substatements.size() == 0 && this.hasEmptyEffectiveSubstatements();
    }

    final AbstractResumedStatement<?, ?, ?> lookupSubstatement(int offset) {
        return this.substatements.get(offset);
    }

    final void resizeSubstatements(int expectedSize) {
        this.substatements = this.substatements.ensureCapacity(expectedSize);
    }

    final void walkChildren(ModelProcessingPhase phase) {
        Preconditions.checkState((boolean)this.isFullyDefined());
        this.substatements.forEach(stmt -> {
            stmt.walkChildren(phase);
            stmt.endDeclared(phase);
        });
    }

    private AbstractResumedStatement<?, ?, ?> createImplicitParent(int offset, StatementSupport<?, ?, ?> implicitParent, StatementSourceReference ref, String argument) {
        StatementDefinitionContext def = new StatementDefinitionContext(implicitParent);
        return this.createSubstatement(offset, def, (StatementSourceReference)ImplicitSubstatement.of((StatementSourceReference)ref), argument);
    }
}

