/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextDefaults;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementContextBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InferredStatementContext<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends StatementContextBase<A, D, E>
implements NamespaceBehaviour.OnDemandSchemaTreeStorageNode {
    private static final Logger LOG = LoggerFactory.getLogger(InferredStatementContext.class);
    private final @NonNull StatementContextBase<A, D, E> prototype;
    private final @NonNull StatementContextBase<?, ?, ?> parent;
    private final @NonNull StmtContext<A, D, E> originalCtx;
    private final @NonNull CopyType childCopyType;
    private final QNameModule targetModule;
    private final A argument;
    private static final ImmutableSet<YangStmtMapping> REUSED_DEF_SET = ImmutableSet.of((Object)YangStmtMapping.TYPE, (Object)YangStmtMapping.TYPEDEF, (Object)YangStmtMapping.USES);

    private InferredStatementContext(InferredStatementContext<A, D, E> original, StatementContextBase<?, ?, ?> parent) {
        super(original);
        this.parent = Objects.requireNonNull(parent);
        this.childCopyType = original.childCopyType;
        this.targetModule = original.targetModule;
        this.prototype = original.prototype;
        this.originalCtx = original.originalCtx;
        this.argument = original.argument;
        this.setSubstatementsInitialized();
    }

    InferredStatementContext(StatementContextBase<?, ?, ?> parent, StatementContextBase<A, D, E> prototype, CopyType myCopyType, CopyType childCopyType, QNameModule targetModule) {
        super(prototype.definition(), CopyHistory.of((CopyType)myCopyType, (CopyHistory)prototype.getCopyHistory()));
        this.parent = Objects.requireNonNull(parent);
        this.prototype = Objects.requireNonNull(prototype);
        this.argument = targetModule == null ? prototype.getStatementArgument() : prototype.definition().adaptArgumentValue((StmtContext<A, D, E>)prototype, targetModule);
        this.childCopyType = Objects.requireNonNull(childCopyType);
        this.targetModule = targetModule;
        this.originalCtx = (StmtContext)prototype.getOriginalCtx().orElse(prototype);
    }

    @Override
    public Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements() {
        return ImmutableList.of();
    }

    public Iterable<? extends StmtContext<?, ?, ?>> allSubstatements() {
        return this.effectiveSubstatements();
    }

    public Stream<? extends StmtContext<?, ?, ?>> allSubstatementsStream() {
        return this.effectiveSubstatements().stream();
    }

    public StatementSourceReference getStatementSourceReference() {
        return this.originalCtx.getStatementSourceReference();
    }

    public String rawStatementArgument() {
        return this.originalCtx.rawStatementArgument();
    }

    public Optional<StmtContext<A, D, E>> getOriginalCtx() {
        return Optional.of(this.originalCtx);
    }

    public Optional<StmtContext<A, D, E>> getPreviousCopyCtx() {
        return Optional.of(this.prototype);
    }

    public D buildDeclared() {
        return (D)this.originalCtx.buildDeclared();
    }

    @Override
    InferredStatementContext<A, D, E> reparent(StatementContextBase<?, ?, ?> newParent) {
        return new InferredStatementContext<A, D, E>(this, newParent);
    }

    @Override
    boolean hasEmptySubstatements() {
        this.ensureEffectiveSubstatements();
        return this.hasEmptyEffectiveSubstatements();
    }

    public <X, Z extends EffectiveStatement<X, ?>> @NonNull Optional<X> findSubstatementArgument(@NonNull Class<Z> type) {
        if (this.substatementsInitialized()) {
            return StmtContextDefaults.findSubstatementArgument((StmtContext)this, type);
        }
        Optional templateArg = this.prototype.findSubstatementArgument(type);
        if (templateArg.isEmpty()) {
            return templateArg;
        }
        if (SchemaTreeEffectiveStatement.class.isAssignableFrom(type)) {
            return templateArg.map(template -> ((QName)template).bindTo(this.targetModule));
        }
        return templateArg;
    }

    public boolean hasSubstatement(@NonNull Class<? extends EffectiveStatement<?, ?>> type) {
        return this.substatementsInitialized() ? StmtContextDefaults.hasSubstatement(this.prototype, type) : this.prototype.hasSubstatement(type);
    }

    public <D extends DeclaredStatement<QName>, E extends EffectiveStatement<QName, D>> StmtContext<QName, D, E> requestSchemaTreeChild(QName qname) {
        LOG.debug("Materializing on lookup of {}", (Object)qname);
        this.ensureEffectiveSubstatements();
        for (StmtContext stmtContext : super.mutableEffectiveSubstatements()) {
            if (!stmtContext.producesEffective(SchemaTreeEffectiveStatement.class) || !qname.equals(stmtContext.coerceStatementArgument())) continue;
            return stmtContext;
        }
        return null;
    }

    @Override
    void ensureEffectiveSubstatements() {
        if (!this.substatementsInitialized()) {
            this.initializeSubstatements();
        }
    }

    @Override
    Iterable<StatementContextBase<?, ?, ?>> effectiveChildrenToComplete() {
        return this.substatementsInitialized() ? super.effectiveChildrenToComplete() : List.of();
    }

    private void initializeSubstatements() {
        Collection<StatementContextBase<?, ?, ?>> declared = this.prototype.mutableDeclaredSubstatements();
        Collection<StmtContext.Mutable<?, ?, ?>> effective = this.prototype.mutableEffectiveSubstatements();
        ArrayList buffer = new ArrayList(declared.size() + effective.size());
        for (StmtContext.Mutable mutable : declared) {
            if (!mutable.isSupportedByFeatures()) continue;
            this.copySubstatement(mutable, buffer);
        }
        for (StmtContext.Mutable mutable : effective) {
            this.copySubstatement(mutable, buffer);
        }
        this.addInitialEffectiveSubstatements(buffer);
    }

    private void copySubstatement(StmtContext.Mutable<?, ?, ?> substatement, Collection<StmtContext.Mutable<?, ?, ?>> buffer) {
        StatementDefinition def = substatement.getPublicDefinition();
        if (REUSED_DEF_SET.contains((Object)def)) {
            LOG.debug("Reusing substatement {} for {}", substatement, (Object)this);
            buffer.add(substatement);
            return;
        }
        substatement.copyAsChildOf((StmtContext.Mutable)this, this.childCopyType, this.targetModule).ifPresent(buffer::add);
    }

    @Deprecated
    public Optional<SchemaPath> getSchemaPath() {
        return this.substatementGetSchemaPath();
    }

    public A getStatementArgument() {
        return this.argument;
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentContext() {
        return this.parent;
    }

    public NamespaceBehaviour.StorageNodeType getStorageNodeType() {
        return NamespaceBehaviour.StorageNodeType.STATEMENT_LOCAL;
    }

    @Override
    public StatementContextBase<?, ?, ?> getParentNamespaceStorage() {
        return this.parent;
    }

    @Override
    public RootStatementContext<?, ?, ?> getRoot() {
        return this.parent.getRoot();
    }

    public boolean isConfiguration() {
        return this.isConfiguration(this.parent);
    }

    @Override
    protected boolean isIgnoringIfFeatures() {
        return this.isIgnoringIfFeatures(this.parent);
    }

    @Override
    protected boolean isIgnoringConfig() {
        return this.isIgnoringConfig(this.parent);
    }

    @Override
    protected boolean isParentSupportedByFeatures() {
        return this.parent.isSupportedByFeatures();
    }
}

