/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;

abstract class NamespaceStorageSupport
implements NamespaceBehaviour.NamespaceStorageNode {
    private Map<Class<?>, Map<?, ?>> namespaces = ImmutableMap.of();

    NamespaceStorageSupport() {
    }

    public abstract NamespaceBehaviour.NamespaceStorageNode getParentNamespaceStorage();

    public abstract NamespaceBehaviour.Registry getBehaviourRegistry();

    protected void checkLocalNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> type) {
    }

    protected <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceElementAdded(Class<N> type, K key, V value) {
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Optional<Map.Entry<K, V>> getFromNamespace(Class<N> type, NamespaceKeyCriterion<K> criterion) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom((NamespaceBehaviour.NamespaceStorageNode)this, criterion);
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getNamespace(Class<N> type) {
        return this.getBehaviourRegistry().getNamespaceBehaviour(type).getAllFrom((NamespaceBehaviour.NamespaceStorageNode)this);
    }

    final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getLocalNamespace(Class<N> type) {
        return this.namespaces.get(type);
    }

    final <K, V, T extends K, U extends V, N extends IdentifierNamespace<K, V>> void addToNamespace(Class<N> type, T key, U value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    final <K, V, T extends K, U extends V, N extends IdentifierNamespace<K, V>> void addToNamespace(Class<N> type, Map<T, U> map) {
        NamespaceBehaviour behavior = this.getBehaviourRegistry().getNamespaceBehaviour(type);
        for (Map.Entry<T, U> validationBundle : map.entrySet()) {
            behavior.addTo((NamespaceBehaviour.NamespaceStorageNode)this, validationBundle.getKey(), validationBundle.getValue());
        }
    }

    public final <K, N extends StatementNamespace<K, ?, ?>> void addContextToNamespace(Class<N> type, K key, StmtContext<?, ?, ?> value) {
        this.getBehaviourRegistry().getNamespaceBehaviour(type).addTo((NamespaceBehaviour.NamespaceStorageNode)this, key, value);
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V getFromLocalStorage(Class<N> type, K key) {
        Map<?, ?> localNamespace = this.namespaces.get(type);
        return localNamespace == null ? null : (V)localNamespace.get(key);
    }

    public <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromLocalStorage(Class<N> type) {
        Map<?, ?> localNamespace = this.namespaces.get(type);
        return localNamespace;
    }

    private <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> ensureLocalNamespace(Class<N> type) {
        Map<?, ?> ret = this.namespaces.get(type);
        if (ret == null) {
            this.checkLocalNamespaceAllowed(type);
            ret = new HashMap(1);
            switch (this.namespaces.size()) {
                case 0: {
                    this.namespaces = ImmutableMap.of(type, ret);
                    break;
                }
                case 1: {
                    HashMap newNamespaces = new HashMap(4);
                    Map.Entry<Class<?>, Map<?, ?>> entry = this.namespaces.entrySet().iterator().next();
                    newNamespaces.put(entry.getKey(), entry.getValue());
                    this.namespaces = newNamespaces;
                }
                default: {
                    this.namespaces.put(type, ret);
                }
            }
        }
        return ret;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V putToLocalStorage(Class<N> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).put(key, value);
        this.onNamespaceElementAdded(type, key, value);
        return ret;
    }

    public <K, V, N extends IdentifierNamespace<K, V>> V putToLocalStorageIfAbsent(Class<N> type, K key, V value) {
        V ret = this.ensureLocalNamespace(type).putIfAbsent(key, value);
        if (ret == null) {
            this.onNamespaceElementAdded(type, key, value);
        }
        return ret;
    }
}

