/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.stmt.reactor;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.IdentifierNamespace;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ConfigEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DeviationStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RefineStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesStatement;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyHistory;
import org.opendaylight.yangtools.yang.parser.spi.meta.CopyType;
import org.opendaylight.yangtools.yang.parser.spi.meta.ImplicitParentAwareStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.InferenceException;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelActionBuilder;
import org.opendaylight.yangtools.yang.parser.spi.meta.ModelProcessingPhase;
import org.opendaylight.yangtools.yang.parser.spi.meta.MutableStatement;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceBehaviour;
import org.opendaylight.yangtools.yang.parser.spi.meta.NamespaceKeyCriterion;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImplicitSubstatement;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;
import org.opendaylight.yangtools.yang.parser.spi.source.SupportedFeaturesNamespace;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.InferredStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceBehaviourWithListeners;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.NamespaceStorageSupport;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.RootStatementContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.StatementDefinitionContext;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.SubstatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StatementContextBase<A, D extends DeclaredStatement<A>, E extends EffectiveStatement<A, D>>
extends NamespaceStorageSupport
implements StmtContext.Mutable<A, D, E> {
    private static final Logger LOG = LoggerFactory.getLogger(StatementContextBase.class);
    private static final int IS_SUPPORTED_BY_FEATURES = 1;
    private static final int HAVE_SUPPORTED_BY_FEATURES = 2;
    private static final int IS_IGNORE_IF_FEATURE = 4;
    private static final int HAVE_IGNORE_IF_FEATURE = 8;
    private static final int IS_IGNORE_CONFIG = 16;
    private static final int HAVE_IGNORE_CONFIG = 32;
    private static final int IS_CONFIGURATION = 64;
    private static final int HAVE_CONFIGURATION = 128;
    private static final int SET_SUPPORTED_BY_FEATURES = 3;
    private static final int SET_CONFIGURATION = 192;
    private static final int SET_IGNORE_CONFIG = 240;
    private static final int SET_IGNORE_IF_FEATURE = 12;
    private final CopyHistory copyHistory;
    private final @NonNull StatementDefinitionContext<A, D, E> definition;
    private Multimap<ModelProcessingPhase, OnPhaseFinished> phaseListeners = ImmutableMultimap.of();
    private Multimap<ModelProcessingPhase, ContextMutation> phaseMutation = ImmutableMultimap.of();
    private List<StatementContextBase<?, ?, ?>> effective = ImmutableList.of();
    private List<StmtContext<?, ?, ?>> effectOfStatement = ImmutableList.of();
    private @Nullable ModelProcessingPhase completedPhase;
    private @Nullable E effectiveInstance;
    private boolean isSupportedToBuildEffective = true;
    private boolean fullyDefined;
    private boolean substatementsInitialized;
    private byte flags;
    private SchemaPath schemaPath;

    StatementContextBase(StatementContextBase<A, D, E> original) {
        this.copyHistory = original.copyHistory;
        this.definition = original.definition;
        this.isSupportedToBuildEffective = original.isSupportedToBuildEffective;
        this.fullyDefined = original.fullyDefined;
        this.completedPhase = original.completedPhase;
        this.flags = original.flags;
    }

    StatementContextBase(StatementDefinitionContext<A, D, E> def) {
        this.definition = Objects.requireNonNull(def);
        this.copyHistory = CopyHistory.original();
    }

    StatementContextBase(StatementDefinitionContext<A, D, E> def, CopyHistory copyHistory) {
        this.definition = Objects.requireNonNull(def);
        this.copyHistory = Objects.requireNonNull(copyHistory);
    }

    public Collection<? extends StmtContext<?, ?, ?>> getEffectOfStatement() {
        return this.effectOfStatement;
    }

    public void addAsEffectOfStatement(StmtContext<?, ?, ?> ctx) {
        if (this.effectOfStatement.isEmpty()) {
            this.effectOfStatement = new ArrayList(1);
        }
        this.effectOfStatement.add(ctx);
    }

    public void addAsEffectOfStatement(Collection<? extends StmtContext<?, ?, ?>> ctxs) {
        if (ctxs.isEmpty()) {
            return;
        }
        if (this.effectOfStatement.isEmpty()) {
            this.effectOfStatement = new ArrayList(ctxs.size());
        }
        this.effectOfStatement.addAll(ctxs);
    }

    public boolean isSupportedByFeatures() {
        Set supportedFeatures;
        int fl = this.flags & 3;
        if (fl != 0) {
            return fl == 3;
        }
        if (this.isIgnoringIfFeatures()) {
            this.flags = (byte)(this.flags | 3);
            return true;
        }
        if (this.isParentSupportedByFeatures() && ((supportedFeatures = (Set)this.getFromNamespace(SupportedFeaturesNamespace.class, SupportedFeaturesNamespace.SupportedFeatures.SUPPORTED_FEATURES)) == null || StmtContextUtils.checkFeatureSupport((StmtContext)this, (Set)supportedFeatures))) {
            this.flags = (byte)(this.flags | 3);
            return true;
        }
        this.flags = (byte)(this.flags | 2);
        return false;
    }

    protected abstract boolean isParentSupportedByFeatures();

    public boolean isSupportedToBuildEffective() {
        return this.isSupportedToBuildEffective;
    }

    public void setIsSupportedToBuildEffective(boolean isSupportedToBuildEffective) {
        this.isSupportedToBuildEffective = isSupportedToBuildEffective;
    }

    public CopyHistory getCopyHistory() {
        return this.copyHistory;
    }

    public ModelProcessingPhase getCompletedPhase() {
        return this.completedPhase;
    }

    @Deprecated
    final void setCompletedPhase(ModelProcessingPhase completedPhase) {
        this.completedPhase = completedPhase;
    }

    public abstract StatementContextBase<?, ?, ?> getParentContext();

    public abstract RootStatementContext<?, ?, ?> getRoot();

    @Override
    public final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull NamespaceBehaviour.Registry getBehaviourRegistry() {
        return this.getRoot().getBehaviourRegistryImpl();
    }

    public final YangVersion getRootVersion() {
        return this.getRoot().getRootVersionImpl();
    }

    public final void setRootVersion(YangVersion version) {
        this.getRoot().setRootVersionImpl(version);
    }

    public final void addMutableStmtToSeal(MutableStatement mutableStatement) {
        this.getRoot().addMutableStmtToSealImpl(mutableStatement);
    }

    public final void addRequiredSource(SourceIdentifier dependency) {
        this.getRoot().addRequiredSourceImpl(dependency);
    }

    public final void setRootIdentifier(SourceIdentifier identifier) {
        this.getRoot().setRootIdentifierImpl(identifier);
    }

    public final boolean isEnabledSemanticVersioning() {
        return this.getRoot().isEnabledSemanticVersioningImpl();
    }

    public StatementSource getStatementSource() {
        return this.getStatementSourceReference().getStatementSource();
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromCurrentStmtCtxNamespace(Class<N> type) {
        return this.getLocalNamespace(type);
    }

    public final <K, V, N extends IdentifierNamespace<K, V>> Map<K, V> getAllFromNamespace(Class<N> type) {
        return this.getNamespace(type);
    }

    public final <K, V, T extends K, U extends V, N extends IdentifierNamespace<K, V>> void addToNs(Class<@NonNull N> type, T key, U value) {
        this.addToNamespace(type, key, value);
    }

    public abstract Collection<? extends StatementContextBase<?, ?, ?>> mutableDeclaredSubstatements();

    public final <K, V, T extends K, N extends IdentifierNamespace<K, V>> V getFromNamespace(Class<@NonNull N> type, T key) {
        return (V)this.getBehaviourRegistry().getNamespaceBehaviour(type).getFrom((NamespaceBehaviour.NamespaceStorageNode)this, key);
    }

    public final Collection<? extends StmtContext.Mutable<?, ?, ?>> mutableEffectiveSubstatements() {
        this.ensureEffectiveSubstatements();
        if (this.effective instanceof ImmutableCollection) {
            return this.effective;
        }
        return Collections.unmodifiableCollection(this.effective);
    }

    private void shrinkEffective() {
        if (this.effective.isEmpty()) {
            this.effective = ImmutableList.of();
        }
    }

    public final void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef) {
        this.ensureEffectiveSubstatements();
        if (this.effective.isEmpty()) {
            return;
        }
        Iterator<StatementContextBase<?, ?, ?>> iterator = this.effective.iterator();
        while (iterator.hasNext()) {
            StmtContext next = (StmtContext)iterator.next();
            if (!statementDef.equals(next.getPublicDefinition())) continue;
            iterator.remove();
        }
        this.shrinkEffective();
    }

    public final void removeStatementFromEffectiveSubstatements(StatementDefinition statementDef, String statementArg) {
        if (statementArg == null) {
            this.removeStatementFromEffectiveSubstatements(statementDef);
        } else {
            this.ensureEffectiveSubstatements();
        }
        if (this.effective.isEmpty()) {
            return;
        }
        Iterator<StatementContextBase<?, ?, ?>> iterator = this.effective.iterator();
        while (iterator.hasNext()) {
            StmtContext.Mutable next = iterator.next();
            if (!statementDef.equals(next.getPublicDefinition()) || !statementArg.equals(next.rawStatementArgument())) continue;
            iterator.remove();
        }
        this.shrinkEffective();
    }

    @Beta
    public <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StmtContext.Mutable<X, Y, Z> appendImplicitSubstatement(StatementSupport<X, Y, Z> support, String rawArg) {
        SubstatementContext<X, Y, Z> ret = new SubstatementContext<X, Y, Z>(this, new StatementDefinitionContext<X, Y, Z>(support), (StatementSourceReference)ImplicitSubstatement.of((StatementSourceReference)this.getStatementSourceReference()), rawArg);
        support.onStatementAdded(ret);
        this.addEffectiveSubstatement(ret);
        return ret;
    }

    public final void addEffectiveSubstatement(StmtContext.Mutable<?, ?, ?> substatement) {
        StatementContextBase.verifyStatement(substatement);
        this.ensureEffectiveSubstatements();
        this.beforeAddEffectiveStatement(1);
        StatementContextBase stmt = (StatementContextBase)substatement;
        ModelProcessingPhase phase = this.completedPhase;
        if (phase != null) {
            StatementContextBase.ensureCompletedPhase(stmt, phase);
        }
        this.effective.add(stmt);
    }

    public final void addEffectiveSubstatements(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        if (!statements.isEmpty()) {
            statements.forEach(StatementContextBase::verifyStatement);
            this.ensureEffectiveSubstatements();
            this.beforeAddEffectiveStatement(statements.size());
            this.doAddEffectiveSubstatements(statements);
        }
    }

    void ensureEffectiveSubstatements() {
    }

    Iterable<StatementContextBase<?, ?, ?>> effectiveChildrenToComplete() {
        return this.effective;
    }

    final void addInitialEffectiveSubstatements(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        Verify.verify((!this.substatementsInitialized ? 1 : 0) != 0, (String)"Attempted to re-initialized statement {} with {}", (Object)this, statements);
        this.substatementsInitialized = true;
        if (!statements.isEmpty()) {
            statements.forEach(StatementContextBase::verifyStatement);
            this.beforeAddEffectiveStatementUnsafe(statements.size());
            this.doAddEffectiveSubstatements(statements);
        }
    }

    private void doAddEffectiveSubstatements(Collection<? extends StmtContext.Mutable<?, ?, ?>> statements) {
        Collection<StmtContext.Mutable<?, ?, ?>> casted = statements;
        ModelProcessingPhase phase = this.completedPhase;
        if (phase != null) {
            for (StatementContextBase statementContextBase : casted) {
                StatementContextBase.ensureCompletedPhase(statementContextBase, phase);
            }
        }
        this.effective.addAll(casted);
    }

    private static void ensureCompletedPhase(StatementContextBase<?, ?, ?> stmt, ModelProcessingPhase phase) {
        Verify.verify((boolean)stmt.tryToCompletePhase(phase), (String)"Statement %s cannot complete phase %s", stmt, (Object)phase);
    }

    private static void verifyStatement(StmtContext.Mutable<?, ?, ?> stmt) {
        Verify.verify((boolean)(stmt instanceof StatementContextBase), (String)"Unexpected statement %s", stmt);
    }

    private void beforeAddEffectiveStatement(int toAdd) {
        Verify.verify((this.completedPhase != ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Cannot modify finished statement at %s", (Object)this.getStatementSourceReference());
        this.beforeAddEffectiveStatementUnsafe(toAdd);
    }

    private void beforeAddEffectiveStatementUnsafe(int toAdd) {
        ModelProcessingPhase inProgressPhase = this.getRoot().getSourceContext().getInProgressPhase();
        Preconditions.checkState((inProgressPhase == ModelProcessingPhase.FULL_DECLARATION || inProgressPhase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Effective statement cannot be added in declared phase at: %s", (Object)this.getStatementSourceReference());
        if (this.effective.isEmpty()) {
            this.effective = new ArrayList(toAdd);
        }
    }

    final boolean fullyDefined() {
        return this.fullyDefined;
    }

    final void setFullyDefined() {
        this.fullyDefined = true;
    }

    final boolean substatementsInitialized() {
        return this.substatementsInitialized;
    }

    final void setSubstatementsInitialized() {
        this.substatementsInitialized = true;
    }

    public E buildEffective() {
        E existing = this.effectiveInstance;
        return existing != null ? existing : this.loadEffective();
    }

    private E loadEffective() {
        this.effectiveInstance = this.definition.getFactory().createEffective((StmtContext)this);
        return this.effectiveInstance;
    }

    final boolean tryToCompletePhase(ModelProcessingPhase phase) {
        return phase.isCompletedBy(this.completedPhase) || this.doTryToCompletePhase(phase);
    }

    private boolean doTryToCompletePhase(ModelProcessingPhase phase) {
        boolean finished;
        boolean bl = finished = this.phaseMutation.isEmpty() ? true : this.runMutations(phase);
        if (this.completeChildren(phase) && finished) {
            this.onPhaseCompleted(phase);
            return true;
        }
        return false;
    }

    private boolean completeChildren(ModelProcessingPhase phase) {
        boolean finished = true;
        for (StatementContextBase<?, ?, ?> child : this.mutableDeclaredSubstatements()) {
            finished &= child.tryToCompletePhase(phase);
        }
        for (StatementContextBase<?, ?, ?> child : this.effectiveChildrenToComplete()) {
            finished &= child.tryToCompletePhase(phase);
        }
        return finished;
    }

    private boolean runMutations(ModelProcessingPhase phase) {
        Collection openMutations = this.phaseMutation.get((Object)phase);
        return openMutations.isEmpty() ? true : this.runMutations(phase, openMutations);
    }

    private boolean runMutations(ModelProcessingPhase phase, Collection<ContextMutation> openMutations) {
        boolean finished = true;
        Iterator<ContextMutation> it = openMutations.iterator();
        while (it.hasNext()) {
            ContextMutation current = it.next();
            if (current.isFinished()) {
                it.remove();
                continue;
            }
            finished = false;
        }
        if (openMutations.isEmpty()) {
            this.phaseMutation.removeAll((Object)phase);
            this.cleanupPhaseMutation();
        }
        return finished;
    }

    private void cleanupPhaseMutation() {
        if (this.phaseMutation.isEmpty()) {
            this.phaseMutation = ImmutableMultimap.of();
        }
    }

    private void onPhaseCompleted(ModelProcessingPhase phase) {
        this.completedPhase = phase;
        Collection listeners = this.phaseListeners.get((Object)phase);
        if (!listeners.isEmpty()) {
            this.runPhaseListeners(phase, listeners);
        }
    }

    private void runPhaseListeners(ModelProcessingPhase phase, Collection<OnPhaseFinished> listeners) {
        Iterator<OnPhaseFinished> listener = listeners.iterator();
        while (listener.hasNext()) {
            OnPhaseFinished next = listener.next();
            if (!next.phaseFinished(this, phase)) continue;
            listener.remove();
        }
        if (listeners.isEmpty()) {
            this.phaseListeners.removeAll((Object)phase);
            if (this.phaseListeners.isEmpty()) {
                this.phaseListeners = ImmutableMultimap.of();
            }
        }
    }

    void endDeclared(ModelProcessingPhase phase) {
        this.definition.onDeclarationFinished(this, phase);
    }

    protected final @NonNull StatementDefinitionContext<A, D, E> definition() {
        return this.definition;
    }

    @Override
    protected void checkLocalNamespaceAllowed(Class<? extends IdentifierNamespace<?, ?>> type) {
        this.definition.checkNamespaceAllowed(type);
    }

    @Override
    protected <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceElementAdded(Class<N> type, K key, V value) {
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceItemAddedAction(final Class<N> type, final K key, final OnNamespaceItemAdded listener) {
        V potential = this.getFromNamespace(type, key);
        if (potential != null) {
            LOG.trace("Listener on {} key {} satisfied immediately", type, key);
            listener.namespaceItemAdded(this, type, key, potential);
            return;
        }
        this.getBehaviour(type).addListener(new NamespaceBehaviourWithListeners.KeyedValueAddedListener<K>(this, key){

            @Override
            void onValueAdded(Object value) {
                listener.namespaceItemAdded(StatementContextBase.this, type, key, value);
            }
        });
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void onNamespaceItemAddedAction(final Class<N> type, final ModelProcessingPhase phase, final NamespaceKeyCriterion<K> criterion, final OnNamespaceItemAdded listener) {
        V existing = this.getFromNamespace(type, (Object)criterion);
        if (((Optional)existing).isPresent()) {
            Map.Entry entry = (Map.Entry)((Optional)existing).get();
            LOG.debug("Listener on {} criterion {} found a pre-existing match: {}", new Object[]{type, criterion, entry});
            this.waitForPhase(entry.getValue(), type, phase, criterion, listener);
            return;
        }
        NamespaceBehaviourWithListeners<K, V, N> behaviour = this.getBehaviour(type);
        behaviour.addListener(new NamespaceBehaviourWithListeners.PredicateValueAddedListener<K, V>(this){

            @Override
            boolean onValueAdded(K key, V value) {
                if (criterion.match(key)) {
                    LOG.debug("Listener on {} criterion {} matched added key {}", new Object[]{type, criterion, key});
                    StatementContextBase.this.waitForPhase(value, type, phase, criterion, listener);
                    return true;
                }
                return false;
            }
        });
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void selectMatch(Class<N> type, NamespaceKeyCriterion<K> criterion, OnNamespaceItemAdded listener) {
        V optMatch = this.getFromNamespace(type, (Object)criterion);
        Preconditions.checkState((boolean)((Optional)optMatch).isPresent(), (String)"Failed to find a match for criterion %s in namespace %s node %s", criterion, type, (Object)this);
        Map.Entry match = (Map.Entry)((Optional)optMatch).get();
        listener.namespaceItemAdded(this, type, match.getKey(), match.getValue());
    }

    final <K, V, N extends IdentifierNamespace<K, V>> void waitForPhase(Object value, Class<N> type, ModelProcessingPhase phase, NamespaceKeyCriterion<K> criterion, OnNamespaceItemAdded listener) {
        ((StatementContextBase)value).addPhaseCompletedListener(phase, (context, phaseCompleted) -> {
            this.selectMatch(type, criterion, listener);
            return true;
        });
    }

    private <K, V, N extends IdentifierNamespace<K, V>> NamespaceBehaviourWithListeners<K, V, N> getBehaviour(Class<N> type) {
        NamespaceBehaviour behaviour = this.getBehaviourRegistry().getNamespaceBehaviour(type);
        Preconditions.checkArgument((boolean)(behaviour instanceof NamespaceBehaviourWithListeners), (String)"Namespace %s does not support listeners", type);
        return (NamespaceBehaviourWithListeners)behaviour;
    }

    public StatementDefinition getPublicDefinition() {
        return this.definition.getPublicView();
    }

    public ModelActionBuilder newInferenceAction(ModelProcessingPhase phase) {
        return this.getRoot().getSourceContext().newInferenceAction(phase);
    }

    private static <T> Multimap<ModelProcessingPhase, T> newMultimap() {
        return Multimaps.newListMultimap(new EnumMap(ModelProcessingPhase.class), () -> new ArrayList(1));
    }

    void addPhaseCompletedListener(ModelProcessingPhase phase, OnPhaseFinished listener) {
        Objects.requireNonNull(phase, "Statement context processing phase cannot be null");
        Objects.requireNonNull(listener, "Statement context phase listener cannot be null");
        for (ModelProcessingPhase finishedPhase = this.completedPhase; finishedPhase != null; finishedPhase = finishedPhase.getPreviousPhase()) {
            if (!phase.equals((Object)finishedPhase)) continue;
            listener.phaseFinished(this, finishedPhase);
            return;
        }
        if (this.phaseListeners.isEmpty()) {
            this.phaseListeners = StatementContextBase.newMultimap();
        }
        this.phaseListeners.put((Object)phase, (Object)listener);
    }

    final void addMutation(ModelProcessingPhase phase, ContextMutation mutation) {
        for (ModelProcessingPhase finishedPhase = this.completedPhase; finishedPhase != null; finishedPhase = finishedPhase.getPreviousPhase()) {
            Preconditions.checkState((!phase.equals((Object)finishedPhase) ? 1 : 0) != 0, (String)"Mutation registered after phase was completed at: %s", (Object)this.getStatementSourceReference());
        }
        if (this.phaseMutation.isEmpty()) {
            this.phaseMutation = StatementContextBase.newMultimap();
        }
        this.phaseMutation.put((Object)phase, (Object)mutation);
    }

    final void removeMutation(ModelProcessingPhase phase, ContextMutation mutation) {
        if (!this.phaseMutation.isEmpty()) {
            this.phaseMutation.remove((Object)phase, (Object)mutation);
            this.cleanupPhaseMutation();
        }
    }

    public <K, KT extends K, N extends StatementNamespace<K, ?, ?>> void addContext(Class<@NonNull N> namespace, KT key, StmtContext<?, ?, ?> stmt) {
        this.addContextToNamespace(namespace, key, stmt);
    }

    public Optional<? extends StmtContext.Mutable<?, ?, ?>> copyAsChildOf(StmtContext.Mutable<?, ?, ?> parent, CopyType type, QNameModule targetModule) {
        StatementContextBase.checkEffectiveModelCompleted(this);
        StatementSupport<A, D, E> support = this.definition.support();
        StatementSupport.CopyPolicy policy = support.applyCopyPolicy((StmtContext.Mutable)this, parent, type, targetModule);
        switch (policy) {
            case CONTEXT_INDEPENDENT: {
                if (this.hasEmptySubstatements()) {
                    return Optional.of(this);
                }
            }
            case DECLARED_COPY: {
                return Optional.of(parent.childCopyOf((StmtContext)this, type, targetModule));
            }
            case IGNORE: {
                return Optional.empty();
            }
            case REJECT: {
                throw new IllegalStateException("Statement " + support.getPublicView() + " should never be copied");
            }
        }
        throw new IllegalStateException("Unhandled policy " + policy);
    }

    public final StmtContext.Mutable<?, ?, ?> childCopyOf(StmtContext<?, ?, ?> stmt, CopyType type, QNameModule targetModule) {
        StatementContextBase.checkEffectiveModelCompleted(stmt);
        Preconditions.checkArgument((boolean)(stmt instanceof StatementContextBase), (String)"Unsupported statement %s", stmt);
        return this.childCopyOf((StatementContextBase)stmt, type, targetModule);
    }

    private <X, Y extends DeclaredStatement<X>, Z extends EffectiveStatement<X, Y>> StmtContext.Mutable<X, Y, Z> childCopyOf(StatementContextBase<X, Y, Z> original, CopyType type, QNameModule targetModule) {
        InferredStatementContext<X, Y, Z> copy;
        StatementContextBase result;
        Optional<StatementSupport<?, ?, ?>> implicitParent = this.definition.getImplicitParentFor(original.getPublicDefinition());
        if (implicitParent.isPresent()) {
            CopyType childCopyType;
            StatementDefinitionContext def = new StatementDefinitionContext(implicitParent.get());
            result = new SubstatementContext(this, def, original.getStatementSourceReference(), original.rawStatementArgument(), original.getStatementArgument(), type);
            switch (type) {
                case ADDED_BY_AUGMENTATION: {
                    childCopyType = CopyType.ORIGINAL;
                    break;
                }
                case ADDED_BY_USES_AUGMENTATION: {
                    childCopyType = CopyType.ADDED_BY_USES;
                    break;
                }
                default: {
                    childCopyType = type;
                }
            }
            copy = new InferredStatementContext<X, Y, Z>(result, original, childCopyType, type, targetModule);
            result.addEffectiveSubstatement(copy);
        } else {
            copy = new InferredStatementContext<X, Y, Z>(this, original, type, type, targetModule);
            result = copy;
        }
        original.definition.onStatementAdded(copy);
        return result;
    }

    private static void checkEffectiveModelCompleted(StmtContext<?, ?, ?> stmt) {
        ModelProcessingPhase phase = stmt.getCompletedPhase();
        Preconditions.checkState((phase == ModelProcessingPhase.EFFECTIVE_MODEL ? 1 : 0) != 0, (String)"Attempted to copy statement %s which has completed phase %s", stmt, (Object)phase);
    }

    @Beta
    public final boolean hasImplicitParentSupport() {
        return this.definition.getFactory() instanceof ImplicitParentAwareStatementSupport;
    }

    @Beta
    public final StatementContextBase<?, ?, ?> wrapWithImplicit(StatementContextBase<?, ?, ?> original) {
        Optional<StatementSupport<?, ?, ?>> optImplicit = this.definition.getImplicitParentFor(original.getPublicDefinition());
        if (optImplicit.isEmpty()) {
            return original;
        }
        StatementDefinitionContext def = new StatementDefinitionContext(optImplicit.get());
        CopyType type = original.getCopyHistory().getLastOperation();
        SubstatementContext result = new SubstatementContext((StatementContextBase<?, ?, ?>)original.getParentContext(), def, original.getStatementSourceReference(), original.rawStatementArgument(), original.getStatementArgument(), type);
        result.addEffectiveSubstatement(original.reparent(result));
        result.setCompletedPhase(original.getCompletedPhase());
        return result;
    }

    abstract StatementContextBase<A, D, E> reparent(StatementContextBase<?, ?, ?> var1);

    abstract boolean hasEmptySubstatements();

    final boolean hasEmptyEffectiveSubstatements() {
        return this.effective.isEmpty();
    }

    final boolean isConfiguration(StatementContextBase<?, ?, ?> parent) {
        boolean isConfig;
        int fl = this.flags & 0xC0;
        if (fl != 0) {
            return fl == 192;
        }
        if (this.isIgnoringConfig(parent)) {
            return true;
        }
        Optional optConfig = this.findSubstatementArgument(ConfigEffectiveStatement.class);
        if (optConfig.isPresent()) {
            isConfig = (Boolean)optConfig.orElseThrow();
            if (isConfig) {
                InferenceException.throwIf((!parent.isConfiguration() ? 1 : 0) != 0, (StatementSourceReference)this.getStatementSourceReference(), (String)"Parent node has config=false, this node must not be specifed as config=true", (Object[])new Object[0]);
            }
        } else {
            isConfig = parent.isConfiguration();
        }
        this.flags = (byte)(this.flags | (isConfig ? 192 : 128));
        return isConfig;
    }

    protected abstract boolean isIgnoringConfig();

    final boolean isIgnoringConfig(StatementContextBase<?, ?, ?> parent) {
        int fl = this.flags & 0xF0;
        if (fl != 0) {
            return fl == 240;
        }
        if (this.definition.support().isIgnoringConfig() || parent.isIgnoringConfig()) {
            this.flags = (byte)(this.flags | 0xF0);
            return true;
        }
        this.flags = (byte)(this.flags | 0x20);
        return false;
    }

    protected abstract boolean isIgnoringIfFeatures();

    final boolean isIgnoringIfFeatures(StatementContextBase<?, ?, ?> parent) {
        int fl = this.flags & 0xC;
        if (fl != 0) {
            return fl == 12;
        }
        if (this.definition.support().isIgnoringIfFeatures() || parent.isIgnoringIfFeatures()) {
            this.flags = (byte)(this.flags | 0xC);
            return true;
        }
        this.flags = (byte)(this.flags | 8);
        return false;
    }

    @Deprecated
    final @NonNull Optional<SchemaPath> substatementGetSchemaPath() {
        if (this.schemaPath == null) {
            this.schemaPath = this.createSchemaPath(this.coerceParentContext());
        }
        return Optional.ofNullable(this.schemaPath);
    }

    @Deprecated
    private SchemaPath createSchemaPath(StmtContext.Mutable<?, ?, ?> parent) {
        Optional maybeParentPath = parent.getSchemaPath();
        Verify.verify((boolean)maybeParentPath.isPresent(), (String)"Parent %s does not have a SchemaPath", parent);
        SchemaPath parentPath = (SchemaPath)maybeParentPath.get();
        if (StmtContextUtils.isUnknownStatement((StmtContext)this)) {
            return parentPath.createChild(this.getPublicDefinition().getStatementName());
        }
        Object argument = this.getStatementArgument();
        if (argument instanceof QName) {
            QName qname = (QName)argument;
            if (this.producesDeclared(UsesStatement.class)) {
                return maybeParentPath.orElse(null);
            }
            return parentPath.createChild(qname);
        }
        if (argument instanceof String) {
            Optional originalCtx = this.getOriginalCtx();
            QName qname = StmtContextUtils.qnameFromArgument((StmtContext)((StmtContext)originalCtx.orElse(this)), (String)((String)argument));
            return parentPath.createChild(qname);
        }
        if (argument instanceof SchemaNodeIdentifier && (this.producesDeclared(AugmentStatement.class) || this.producesDeclared(RefineStatement.class) || this.producesDeclared(DeviationStatement.class))) {
            return parentPath.createChild((Iterable)((SchemaNodeIdentifier)argument).getNodeIdentifiers());
        }
        return maybeParentPath.orElse(null);
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("definition", this.definition).add("rawArgument", (Object)this.rawStatementArgument());
    }

    static interface ContextMutation {
        public boolean isFinished();
    }

    static interface OnPhaseFinished
    extends EventListener {
        public boolean phaseFinished(StatementContextBase<?, ?, ?> var1, ModelProcessingPhase var2);
    }

    static interface OnNamespaceItemAdded
    extends EventListener {
        public void namespaceItemAdded(StatementContextBase<?, ?, ?> var1, Class<?> var2, Object var3, Object var4);
    }
}

