/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.NodeType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers.NodeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.general.rev131030.node.identifiers.NodeIdentifierKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class NodeIdentifierBuilder
implements Builder<NodeIdentifier> {
    private Uri _identifier;
    private Class<? extends NodeType> _type;
    private NodeIdentifierKey key;
    Map<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>> augmentation = Collections.emptyMap();

    public NodeIdentifierBuilder() {
    }

    public NodeIdentifierBuilder(NodeIdentifier base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>(aug);
        }
        this.key = base.key();
        this._identifier = base.getIdentifier();
        this._type = base.getType();
    }

    public NodeIdentifierKey key() {
        return this.key;
    }

    public Uri getIdentifier() {
        return this._identifier;
    }

    public Class<? extends NodeType> getType() {
        return this._type;
    }

    public <E$$ extends Augmentation<NodeIdentifier>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodeIdentifierBuilder withKey(NodeIdentifierKey key) {
        this.key = key;
        return this;
    }

    public NodeIdentifierBuilder setIdentifier(Uri value) {
        this._identifier = value;
        return this;
    }

    public NodeIdentifierBuilder setType(Class<? extends NodeType> value) {
        this._type = value;
        return this;
    }

    public NodeIdentifierBuilder addAugmentation(Augmentation<NodeIdentifier> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeIdentifier>>, Augmentation<NodeIdentifier>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeIdentifierBuilder removeAugmentation(Class<? extends Augmentation<NodeIdentifier>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NodeIdentifier build() {
        return new NodeIdentifierImpl(this);
    }

    private static final class NodeIdentifierImpl
    extends AbstractAugmentable<NodeIdentifier>
    implements NodeIdentifier {
        private final Uri _identifier;
        private final Class<? extends NodeType> _type;
        private final NodeIdentifierKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeIdentifierImpl(NodeIdentifierBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new NodeIdentifierKey(base.getIdentifier(), base.getType());
            this._identifier = this.key.getIdentifier();
            this._type = this.key.getType();
        }

        @Override
        public NodeIdentifierKey key() {
            return this.key;
        }

        @Override
        public Uri getIdentifier() {
            return this._identifier;
        }

        @Override
        public Class<? extends NodeType> getType() {
            return this._type;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NodeIdentifier.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NodeIdentifier.bindingEquals(this, obj);
        }

        public String toString() {
            return NodeIdentifier.bindingToString(this);
        }
    }
}

