/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.view.rev131030.aggregate.node;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.topology.view.rev131030.aggregate.node.OriginalNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class OriginalNodeBuilder
implements Builder<OriginalNode> {
    private NodeId _node;
    private TopologyId _topology;
    Map<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>> augmentation = Collections.emptyMap();

    public OriginalNodeBuilder() {
    }

    public OriginalNodeBuilder(OriginalNode base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>>(aug);
        }
        this._node = base.getNode();
        this._topology = base.getTopology();
    }

    public NodeId getNode() {
        return this._node;
    }

    public TopologyId getTopology() {
        return this._topology;
    }

    public <E$$ extends Augmentation<OriginalNode>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public OriginalNodeBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public OriginalNodeBuilder setTopology(TopologyId value) {
        this._topology = value;
        return this;
    }

    public OriginalNodeBuilder addAugmentation(Augmentation<OriginalNode> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OriginalNode>>, Augmentation<OriginalNode>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public OriginalNodeBuilder removeAugmentation(Class<? extends Augmentation<OriginalNode>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public OriginalNode build() {
        return new OriginalNodeImpl(this);
    }

    private static final class OriginalNodeImpl
    extends AbstractAugmentable<OriginalNode>
    implements OriginalNode {
        private final NodeId _node;
        private final TopologyId _topology;
        private int hash = 0;
        private volatile boolean hashValid = false;

        OriginalNodeImpl(OriginalNodeBuilder base) {
            super(base.augmentation);
            this._node = base.getNode();
            this._topology = base.getTopology();
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopology() {
            return this._topology;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = OriginalNode.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return OriginalNode.bindingEquals(this, obj);
        }

        public String toString() {
            return OriginalNode.bindingToString(this);
        }
    }
}

