/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.cluster.databroker.AbstractDOMTransactionFactory;
import org.opendaylight.controller.cluster.databroker.DOMBrokerTransactionChain;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohort;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistration;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCommitCohortRegistry;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.spi.PingPongMergingDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTreeChangePublisher;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDOMBroker
extends AbstractDOMTransactionFactory<DOMStore>
implements PingPongMergingDOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDOMBroker.class);
    private final AtomicLong txNum = new AtomicLong();
    private final AtomicLong chainNum = new AtomicLong();
    private final ClassToInstanceMap<DOMDataBrokerExtension> extensions;
    private volatile AutoCloseable closeable;

    protected AbstractDOMBroker(Map<LogicalDatastoreType, DOMStore> datastores) {
        super(datastores);
        ImmutableClassToInstanceMap.Builder extBuilder = ImmutableClassToInstanceMap.builder();
        if (AbstractDOMBroker.isSupported(datastores, DOMStoreTreeChangePublisher.class)) {
            extBuilder.put(DOMDataTreeChangeService.class, (Object)new DOMDataTreeChangeService(){

                public <L extends DOMDataTreeChangeListener> ListenerRegistration<L> registerDataTreeChangeListener(DOMDataTreeIdentifier treeId, L listener) {
                    DOMStore store = AbstractDOMBroker.this.getDOMStore(treeId.getDatastoreType());
                    return ((DOMStoreTreeChangePublisher)store).registerTreeChangeListener(treeId.getRootIdentifier(), listener);
                }
            });
        }
        if (AbstractDOMBroker.isSupported(datastores, DOMDataTreeCommitCohortRegistry.class)) {
            extBuilder.put(DOMDataTreeCommitCohortRegistry.class, (Object)new DOMDataTreeCommitCohortRegistry(){

                public <T extends DOMDataTreeCommitCohort> DOMDataTreeCommitCohortRegistration<T> registerCommitCohort(DOMDataTreeIdentifier path, T cohort) {
                    DOMStore store = AbstractDOMBroker.this.getDOMStore(path.getDatastoreType());
                    return ((DOMDataTreeCommitCohortRegistry)store).registerCommitCohort(path, cohort);
                }
            });
        }
        this.extensions = extBuilder.build();
    }

    private static boolean isSupported(Map<LogicalDatastoreType, DOMStore> datastores, Class<?> expDOMStoreInterface) {
        return datastores.values().stream().allMatch(expDOMStoreInterface::isInstance);
    }

    public void setCloseable(AutoCloseable closeable) {
        this.closeable = closeable;
    }

    @Override
    public void close() {
        super.close();
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (Exception e) {
                LOG.debug("Error closing instance", (Throwable)e);
            }
        }
    }

    @Override
    protected Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }

    public ClassToInstanceMap<DOMDataBrokerExtension> getExtensions() {
        return this.extensions;
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        this.checkNotClosed();
        EnumMap<LogicalDatastoreType, DOMStoreTransactionChain> backingChains = new EnumMap<LogicalDatastoreType, DOMStoreTransactionChain>(LogicalDatastoreType.class);
        for (Map.Entry entry : this.getTxFactories().entrySet()) {
            backingChains.put(entry.getKey(), ((DOMStore)entry.getValue()).createTransactionChain());
        }
        long chainId = this.chainNum.getAndIncrement();
        LOG.debug("Transaction chain {} created with listener {}, backing store chains {}", new Object[]{chainId, listener, backingChains});
        return new DOMBrokerTransactionChain(chainId, backingChains, this, listener);
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="https://github.com/spotbugs/spotbugs/issues/811")
    private DOMStore getDOMStore(LogicalDatastoreType type) {
        DOMStore store = (DOMStore)this.getTxFactories().get(type);
        Preconditions.checkState((store != null ? 1 : 0) != 0, (Object)"Requested logical data store is not available.");
        return store;
    }
}

