/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.StampedLock;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.InversibleLockException;
import org.opendaylight.controller.cluster.access.commands.CreateLocalHistoryRequest;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.Request;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHandle;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientSnapshot;
import org.opendaylight.controller.cluster.databroker.actors.dds.ClientTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.HistoryReconnectCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalAbortable;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyReconnectCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.ShardBackendInfo;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainClosedException;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientHistory
extends LocalAbortable
implements Identifiable<LocalHistoryIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractClientHistory.class);
    private static final AtomicLongFieldUpdater<AbstractClientHistory> NEXT_TX_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractClientHistory.class, "nextTx");
    private static final AtomicReferenceFieldUpdater<AbstractClientHistory, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractClientHistory.class, State.class, "state");
    private final @GuardedBy(value={"this"}) Map<TransactionIdentifier, AbstractClientHandle<?>> openTransactions = new HashMap();
    private final @GuardedBy(value={"this"}) Map<TransactionIdentifier, AbstractTransactionCommitCohort> readyTransactions = new HashMap<TransactionIdentifier, AbstractTransactionCommitCohort>();
    private final @GuardedBy(value={"lock"}) Map<Long, ProxyHistory> histories = new ConcurrentHashMap<Long, ProxyHistory>();
    private final StampedLock lock = new StampedLock();
    private final @NonNull AbstractDataStoreClientBehavior client;
    private final @NonNull LocalHistoryIdentifier identifier;
    private volatile long nextTx = 0L;
    private volatile State state = State.IDLE;

    AbstractClientHistory(AbstractDataStoreClientBehavior client, LocalHistoryIdentifier identifier) {
        this.client = Objects.requireNonNull(client);
        this.identifier = Objects.requireNonNull(identifier);
        Preconditions.checkArgument((identifier.getCookie() == 0L ? 1 : 0) != 0);
    }

    final State state() {
        return this.state;
    }

    final void updateState(State expected, State next) {
        boolean success = STATE_UPDATER.compareAndSet(this, expected, next);
        Preconditions.checkState((boolean)success, (String)"Race condition detected, state changed from %s to %s", (Object)((Object)expected), (Object)((Object)this.state));
        LOG.debug("Client history {} changed state from {} to {}", new Object[]{this, expected, next});
    }

    final synchronized void doClose() {
        State local = this.state;
        if (local != State.CLOSED) {
            Preconditions.checkState((local == State.IDLE ? 1 : 0) != 0, (String)"Local history %s has an open transaction", (Object)this);
            this.histories.values().forEach(ProxyHistory::close);
            this.updateState(local, State.CLOSED);
        }
    }

    final synchronized void onProxyDestroyed(ProxyHistory proxyHistory) {
        this.histories.remove(proxyHistory.getIdentifier().getCookie());
        LOG.debug("{}: removed destroyed proxy {}", (Object)this, (Object)proxyHistory);
    }

    public LocalHistoryIdentifier getIdentifier() {
        return this.identifier;
    }

    final long nextTx() {
        return NEXT_TX_UPDATER.getAndIncrement(this);
    }

    final Long resolveShardForPath(YangInstanceIdentifier path) {
        return this.client.resolveShardForPath(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void localAbort(Throwable cause) {
        State oldState = STATE_UPDATER.getAndSet(this, State.CLOSED);
        if (oldState != State.CLOSED) {
            LOG.debug("Force-closing history {}", (Object)this.getIdentifier(), (Object)cause);
            AbstractClientHistory abstractClientHistory = this;
            synchronized (abstractClientHistory) {
                for (AbstractClientHandle<?> t : this.openTransactions.values()) {
                    t.localAbort(cause);
                }
                this.openTransactions.clear();
                this.readyTransactions.clear();
            }
        }
    }

    @Holding(value={"lock"})
    private ProxyHistory createHistoryProxy(Long shard) {
        AbstractClientConnection connection = this.client.getConnection(shard);
        LocalHistoryIdentifier proxyId = new LocalHistoryIdentifier(this.identifier.getClientId(), this.identifier.getHistoryId(), shard.longValue());
        LOG.debug("Created proxyId {} for history {} shard {}", new Object[]{proxyId, this.identifier, shard});
        ProxyHistory ret = this.createHistoryProxy(proxyId, (AbstractClientConnection<ShardBackendInfo>)connection);
        if (ret.getIdentifier().getHistoryId() != 0L) {
            connection.sendRequest((Request)new CreateLocalHistoryRequest(ret.getIdentifier(), connection.localActor()), this::createHistoryCallback);
        }
        return ret;
    }

    abstract ProxyHistory createHistoryProxy(LocalHistoryIdentifier var1, AbstractClientConnection<ShardBackendInfo> var2);

    private void createHistoryCallback(Response<?, ?> response) {
        LOG.debug("Create history response {}", response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @NonNull ProxyHistory ensureHistoryProxy(TransactionIdentifier transactionId, Long shard) {
        while (true) {
            long stamp = this.lock.readLock();
            try {
                ProxyHistory proxyHistory = this.histories.computeIfAbsent(shard, this::createHistoryProxy);
                this.lock.unlockRead(stamp);
                return proxyHistory;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.unlockRead(stamp);
                    throw throwable;
                }
                catch (InversibleLockException e) {
                    LOG.trace("Waiting for transaction {} shard {} connection to resolve", (Object)transactionId, (Object)shard);
                    e.awaitResolution();
                    LOG.trace("Retrying transaction {} shard {} connection", (Object)transactionId, (Object)shard);
                    continue;
                }
            }
            break;
        }
    }

    final @NonNull AbstractProxyTransaction createSnapshotProxy(TransactionIdentifier transactionId, Long shard) {
        return this.ensureHistoryProxy(transactionId, shard).createTransactionProxy(transactionId, true);
    }

    final @NonNull AbstractProxyTransaction createTransactionProxy(TransactionIdentifier transactionId, Long shard) {
        return this.ensureHistoryProxy(transactionId, shard).createTransactionProxy(transactionId, false);
    }

    private void checkNotClosed() {
        if (this.state == State.CLOSED) {
            throw new DOMTransactionChainClosedException(String.format("Local history %s is closed", this.identifier));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull ClientTransaction createTransaction() {
        this.checkNotClosed();
        AbstractClientHistory abstractClientHistory = this;
        synchronized (abstractClientHistory) {
            ClientTransaction ret = this.doCreateTransaction();
            this.openTransactions.put(ret.getIdentifier(), ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSnapshot takeSnapshot() {
        this.checkNotClosed();
        AbstractClientHistory abstractClientHistory = this;
        synchronized (abstractClientHistory) {
            ClientSnapshot ret = this.doCreateSnapshot();
            this.openTransactions.put(ret.getIdentifier(), ret);
            return ret;
        }
    }

    @Holding(value={"this"})
    abstract ClientSnapshot doCreateSnapshot();

    @Holding(value={"this"})
    abstract ClientTransaction doCreateTransaction();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTransactionShardsBound(TransactionIdentifier txId, Set<Long> participatingShards) {
        long stamp = this.lock.readLock();
        try {
            for (Map.Entry<Long, ProxyHistory> entry : this.histories.entrySet()) {
                if (participatingShards.contains(entry.getKey())) continue;
                entry.getValue().skipTransaction(txId);
            }
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    synchronized AbstractTransactionCommitCohort onTransactionReady(ClientTransaction tx, AbstractTransactionCommitCohort cohort) {
        AbstractTransactionCommitCohort previous;
        TransactionIdentifier txId = tx.getIdentifier();
        if (this.openTransactions.remove(txId) == null) {
            LOG.warn("Transaction {} not recorded, proceeding with readiness", (Object)txId);
        }
        Preconditions.checkState(((previous = this.readyTransactions.putIfAbsent(txId, cohort)) == null ? 1 : 0) != 0, (String)"Duplicate cohort %s for transaction %s, already have %s", (Object)cohort, (Object)txId, (Object)previous);
        LOG.debug("Local history {} readied transaction {}", (Object)this, (Object)txId);
        return cohort;
    }

    synchronized void onTransactionAbort(AbstractClientHandle<?> snapshot) {
        if (this.openTransactions.remove(snapshot.getIdentifier()) == null) {
            LOG.warn("Could not find aborting transaction {}", (Object)snapshot.getIdentifier());
        }
    }

    synchronized void onTransactionComplete(TransactionIdentifier txId) {
        if (this.readyTransactions.remove(txId) == null) {
            LOG.warn("Could not find completed transaction {}", (Object)txId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final HistoryReconnectCohort startReconnect(final ConnectedClientConnection<ShardBackendInfo> newConn) {
        ProxyHistory oldProxy;
        long stamp = this.lock.writeLock();
        try {
            oldProxy = this.histories.get(newConn.cookie());
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
        if (oldProxy == null) {
            return null;
        }
        final ProxyReconnectCohort proxy = (ProxyReconnectCohort)Verify.verifyNotNull((Object)oldProxy.startReconnect(newConn));
        return new HistoryReconnectCohort(){

            @Override
            ProxyReconnectCohort getProxy() {
                return proxy;
            }

            @Override
            void replayRequests(Collection<ConnectionEntry> previousEntries) {
                proxy.replayRequests(previousEntries);
            }

            @Override
            public void close() {
                LOG.debug("Client history {} finishing reconnect to {}", (Object)AbstractClientHistory.this, (Object)newConn);
                ProxyHistory newProxy = proxy.finishReconnect();
                if (!AbstractClientHistory.this.histories.replace(newConn.cookie(), oldProxy, newProxy)) {
                    LOG.warn("Failed to replace proxy {} with {} in {}", new Object[]{oldProxy, newProxy, AbstractClientHistory.this});
                }
            }
        };
    }

    static enum State {
        IDLE,
        TX_OPEN,
        CLOSED;

    }
}

