/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractClientHistory;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractTransactionCommitCohort;
import org.opendaylight.controller.cluster.databroker.actors.dds.VotingFuture;

final class ClientTransactionCommitCohort
extends AbstractTransactionCommitCohort {
    private final Collection<AbstractProxyTransaction> proxies;

    ClientTransactionCommitCohort(AbstractClientHistory parent, TransactionIdentifier txId, Collection<AbstractProxyTransaction> proxies) {
        super(parent, txId);
        this.proxies = ImmutableList.copyOf(proxies);
    }

    public ListenableFuture<Boolean> canCommit() {
        VotingFuture<Boolean> ret = new VotingFuture<Boolean>(Boolean.TRUE, this.proxies.size());
        for (AbstractProxyTransaction proxy : this.proxies) {
            proxy.canCommit(ret);
        }
        return ret;
    }

    private ListenableFuture<Void> addComplete(ListenableFuture<Void> future) {
        future.addListener(this::complete, MoreExecutors.directExecutor());
        return future;
    }

    public ListenableFuture<Void> preCommit() {
        VotingFuture<Object> ret = new VotingFuture<Object>(null, this.proxies.size());
        for (AbstractProxyTransaction proxy : this.proxies) {
            proxy.preCommit(ret);
        }
        return ret;
    }

    public ListenableFuture<Void> commit() {
        VotingFuture<Object> ret = new VotingFuture<Object>(null, this.proxies.size());
        for (AbstractProxyTransaction proxy : this.proxies) {
            proxy.doCommit(ret);
        }
        return this.addComplete((ListenableFuture<Void>)ret);
    }

    public ListenableFuture<Void> abort() {
        VotingFuture<Object> ret = new VotingFuture<Object>(null, this.proxies.size());
        for (AbstractProxyTransaction proxy : this.proxies) {
            proxy.abort(ret);
        }
        return this.addComplete((ListenableFuture<Void>)ret);
    }
}

