/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.opendaylight.controller.cluster.access.commands.CommitLocalTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.ModifyTransactionRequest;
import org.opendaylight.controller.cluster.access.commands.PersistenceProtocol;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.databroker.actors.dds.LocalProxyTransaction;
import org.opendaylight.controller.cluster.databroker.actors.dds.ProxyHistory;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;

final class LocalReadOnlyProxyTransaction
extends LocalProxyTransaction {
    private final DataTreeSnapshot snapshot;

    LocalReadOnlyProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier, DataTreeSnapshot snapshot) {
        super(parent, identifier, false);
        this.snapshot = Objects.requireNonNull(snapshot);
    }

    LocalReadOnlyProxyTransaction(ProxyHistory parent, TransactionIdentifier identifier) {
        super(parent, identifier, true);
        this.snapshot = null;
    }

    @Override
    boolean isSnapshotOnly() {
        return true;
    }

    @Override
    DataTreeSnapshot readOnlyView() {
        return (DataTreeSnapshot)Preconditions.checkNotNull((Object)this.snapshot, (String)"Transaction %s is DONE", (Object)this.getIdentifier());
    }

    @Override
    void doDelete(YangInstanceIdentifier path) {
        throw new UnsupportedOperationException("doDelete");
    }

    @Override
    void doMerge(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        throw new UnsupportedOperationException("doMerge");
    }

    @Override
    void doWrite(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        throw new UnsupportedOperationException("doWrite");
    }

    CommitLocalTransactionRequest commitRequest(boolean coordinated) {
        throw new UnsupportedOperationException("commitRequest");
    }

    @Override
    Optional<ModifyTransactionRequest> flushState() {
        return Optional.empty();
    }

    @Override
    void applyForwardedModifyTransactionRequest(ModifyTransactionRequest request, Consumer<Response<?, ?>> callback) {
        LocalReadOnlyProxyTransaction.commonModifyTransactionRequest(request);
        this.abort();
    }

    @Override
    void replayModifyTransactionRequest(ModifyTransactionRequest request, Consumer<Response<?, ?>> callback, long enqueuedTicks) {
        LocalReadOnlyProxyTransaction.commonModifyTransactionRequest(request);
        this.enqueueAbort(callback, enqueuedTicks);
    }

    private static void commonModifyTransactionRequest(ModifyTransactionRequest request) {
        Verify.verify((boolean)request.getModifications().isEmpty());
        PersistenceProtocol protocol = (PersistenceProtocol)request.getPersistenceProtocol().get();
        Verify.verify((protocol == PersistenceProtocol.ABORT ? 1 : 0) != 0);
    }
}

