/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.ActorRef;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedLong;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.access.ABIVersion;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ReadOnlyDataTree;

final class ShardBackendInfo
extends BackendInfo {
    private final Optional<ReadOnlyDataTree> dataTree;
    private final UnsignedLong cookie;

    ShardBackendInfo(ActorRef actor, long sessionId, ABIVersion version, String shardName, UnsignedLong cookie, Optional<ReadOnlyDataTree> dataTree, int maxMessages) {
        super(actor, shardName, sessionId, version, maxMessages);
        this.cookie = Objects.requireNonNull(cookie);
        this.dataTree = Objects.requireNonNull(dataTree);
    }

    UnsignedLong getCookie() {
        return this.cookie;
    }

    Optional<ReadOnlyDataTree> getDataTree() {
        return this.dataTree;
    }

    LocalHistoryIdentifier brandHistory(LocalHistoryIdentifier id) {
        Preconditions.checkArgument((id.getCookie() == 0L ? 1 : 0) != 0, (String)"History %s is already branded", (Object)id);
        return new LocalHistoryIdentifier(id.getClientId(), id.getHistoryId(), this.cookie.longValue());
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("cookie", (Object)this.cookie).add("shard", (Object)this.getName()).add("dataTree", (Object)(this.getDataTree().isPresent() ? "present" : "absent"));
    }
}

