/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.databroker.actors.dds;

import akka.actor.Props;
import akka.japi.Creator;
import java.io.Serializable;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientActor;
import org.opendaylight.controller.cluster.databroker.actors.dds.AbstractDataStoreClientBehavior;
import org.opendaylight.controller.cluster.databroker.actors.dds.SimpleDataStoreClientBehavior;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;

public final class SimpleDataStoreClientActor
extends AbstractDataStoreClientActor {
    private final String shardName;

    private SimpleDataStoreClientActor(FrontendIdentifier frontendId, ActorUtils actorUtils, String shardName) {
        super(frontendId, actorUtils);
        this.shardName = Objects.requireNonNull(shardName);
    }

    @Override
    AbstractDataStoreClientBehavior initialBehavior(ClientActorContext context, ActorUtils actorUtils) {
        return new SimpleDataStoreClientBehavior(context, actorUtils, this.shardName);
    }

    public static Props props(@NonNull MemberName memberName, @NonNull String storeName, ActorUtils actorUtils, String shardName) {
        String name = "datastore-" + storeName;
        FrontendIdentifier frontendId = FrontendIdentifier.create((MemberName)memberName, (FrontendType)FrontendType.forName((String)name));
        return Props.create(SimpleDataStoreClientActor.class, (Creator & Serializable)() -> new SimpleDataStoreClientActor(frontendId, actorUtils, shardName));
    }
}

