/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospector;
import org.opendaylight.controller.cluster.datastore.DatastoreContextIntrospectorFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.distributed.datastore.provider.rev140612.DataStorePropertiesContainer;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

abstract class AbstractDatastoreContextIntrospectorFactory
implements DatastoreContextIntrospectorFactory {
    AbstractDatastoreContextIntrospectorFactory() {
    }

    @Override
    public DatastoreContextIntrospector newInstance(LogicalDatastoreType datastoreType, Map<String, Object> properties) {
        DatastoreContextIntrospector inst = this.newInstance(datastoreType);
        inst.update(properties);
        return inst;
    }

    @VisibleForTesting
    final DatastoreContextIntrospector newInstance(LogicalDatastoreType datastoreType) {
        return this.newInstance(DatastoreContext.newBuilder().logicalStoreType(datastoreType).tempFileDirectory("./data").build());
    }

    @VisibleForTesting
    final @NonNull DatastoreContextIntrospector newInstance(DatastoreContext context) {
        DataStorePropertiesContainer defaultPropsContainer = (DataStorePropertiesContainer)this.serializer().fromNormalizedNode(YangInstanceIdentifier.of((QName)DataStorePropertiesContainer.QNAME), (NormalizedNode)ImmutableNodes.containerNode((QName)DataStorePropertiesContainer.QNAME)).getValue();
        return new DatastoreContextIntrospector(context, defaultPropsContainer);
    }

    abstract BindingNormalizedNodeSerializer serializer();
}

