/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Props;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeNotificationPublisher;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeNotificationPublisherActor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractShardDataTreeNotificationPublisherActorProxy
implements ShardDataTreeNotificationPublisher {
    @SuppressFBWarnings(value={"SLF4J_LOGGER_SHOULD_BE_PRIVATE"})
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ActorContext actorContext;
    private final String actorName;
    private final String logContext;
    private ActorRef publisherActor;

    protected AbstractShardDataTreeNotificationPublisherActorProxy(ActorContext actorContext, String actorName, String logContext) {
        this.actorContext = actorContext;
        this.actorName = actorName;
        this.logContext = logContext;
    }

    protected abstract Props props();

    protected final String actorName() {
        return this.actorName;
    }

    protected final String logContext() {
        return this.logContext;
    }

    @Override
    public void publishChanges(DataTreeCandidate candidate) {
        this.publisherActor().tell((Object)new ShardDataTreeNotificationPublisherActor.PublishNotifications(candidate), ActorRef.noSender());
    }

    protected final ActorRef publisherActor() {
        if (this.publisherActor == null) {
            String dispatcher = new Dispatchers(this.actorContext.system().dispatchers()).getDispatcherPath(Dispatchers.DispatcherType.Notification);
            this.publisherActor = this.actorContext.actorOf(this.props().withDispatcher(dispatcher), this.actorName);
            this.log.debug("{}: Created publisher actor {} with name {}", new Object[]{this.logContext, this.publisherActor, this.actorName});
        }
        return this.publisherActor;
    }
}

