/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.ActorSystem;
import com.google.common.annotations.VisibleForTesting;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.datastore.AbstractDataStore;
import org.opendaylight.controller.cluster.datastore.ClusterWrapper;
import org.opendaylight.controller.cluster.datastore.DatastoreContextFactory;
import org.opendaylight.controller.cluster.datastore.TransactionContextFactory;
import org.opendaylight.controller.cluster.datastore.TransactionProxy;
import org.opendaylight.controller.cluster.datastore.TransactionType;
import org.opendaylight.controller.cluster.datastore.config.Configuration;
import org.opendaylight.controller.cluster.datastore.persisted.DatastoreSnapshot;
import org.opendaylight.controller.cluster.datastore.utils.ActorUtils;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreReadWriteTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransactionChain;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreWriteTransaction;

public class DistributedDataStore
extends AbstractDataStore {
    private final TransactionContextFactory txContextFactory = new TransactionContextFactory(this.getActorUtils(), this.getIdentifier());

    public DistributedDataStore(ActorSystem actorSystem, ClusterWrapper cluster, Configuration configuration, DatastoreContextFactory datastoreContextFactory, DatastoreSnapshot restoreFromSnapshot) {
        super(actorSystem, cluster, configuration, datastoreContextFactory, restoreFromSnapshot);
    }

    @VisibleForTesting
    DistributedDataStore(ActorUtils actorUtils, ClientIdentifier identifier) {
        super(actorUtils, identifier);
    }

    public DOMStoreTransactionChain createTransactionChain() {
        return this.txContextFactory.createTransactionChain();
    }

    public DOMStoreReadTransaction newReadOnlyTransaction() {
        return new TransactionProxy(this.txContextFactory, TransactionType.READ_ONLY);
    }

    public DOMStoreWriteTransaction newWriteOnlyTransaction() {
        this.getActorUtils().acquireTxCreationPermit();
        return new TransactionProxy(this.txContextFactory, TransactionType.WRITE_ONLY);
    }

    public DOMStoreReadWriteTransaction newReadWriteTransaction() {
        this.getActorUtils().acquireTxCreationPermit();
        return new TransactionProxy(this.txContextFactory, TransactionType.READ_WRITE);
    }

    @Override
    public void close() {
        this.txContextFactory.close();
        super.close();
    }
}

